/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.objectrepository.constant.ImageConstants;
import com.kms.katalon.composer.objectrepository.part.TestObjectPart;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenTestObjectHandler {
    private static final String TEST_OBJECT_PART_URI = "bundleclass://com.kms.katalon.composer.objectrepository/" + TestObjectPart.class.getName();
    @Inject
    MApplication application;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object.getClass() == WebElementEntity.class) {
                    OpenTestObjectHandler.this.excute((WebElementEntity)object);
                }
            }
        });
    }

    @Inject
    @Optional
    private void getNotifications(@UIEventTopic(value="TESTOBJECT/OPEN") WebElementEntity entity) {
        this.excute(entity);
    }

    public void excute(WebElementEntity testObject) {
        if (testObject != null) {
            String partId = EntityPartUtil.getTestObjectPartId((String)testObject.getId());
            MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
            boolean alreadyOpened = true;
            if (mPart == null) {
                mPart = (MPart)this.modelService.createModelElement(MPart.class);
                mPart.setElementId(partId);
                mPart.setLabel(testObject.getName());
                mPart.setContributionURI(TEST_OBJECT_PART_URI);
                mPart.setCloseable(true);
                mPart.setIconURI(ImageConstants.URL_16_TEST_OBJECT);
                mPart.setTooltip(testObject.getIdForDisplay());
                mPart.getTags().add("removeOnHide");
                stack.getChildren().add(mPart);
                alreadyOpened = false;
            }
            if (mPart.getObject() == null) {
                mPart.setObject((Object)testObject);
            }
            this.partService.showPart(mPart, EPartService.PartState.ACTIVATE);
            this.partService.bringToTop(mPart);
            stack.setSelectedElement((MUIElement)mPart);
            if (!alreadyOpened) {
                Trackings.trackOpenObject((String)"testObject");
            }
        }
    }
}

