/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.objectrepository.constant.StringConstants;
import com.kms.katalon.composer.objectrepository.dialog.NewTestObjectDialog;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NewTestObjectHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;
    @Inject
    EPartService partService;
    @Inject
    private ESelectionService selectionService;
    @Inject
    IEclipseContext context;
    private FolderTreeEntity objectRepositoryTreeRoot;
    private String newDefaultName = StringConstants.HAND_NEW_TEST_OBJ;

    @Inject
    @Optional
    private void executeByEvent(@UIEventTopic(value="TESTOBJECT/NEW") Object unuse) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            ObjectRepositoryController toController;
            String suggestedName;
            FolderEntity parentFolderEntity;
            NewTestObjectDialog dialog;
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (selectedObjects == null) {
                return;
            }
            ITreeEntity parentTreeEntity = NewTestObjectHandler.getParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                if (this.objectRepositoryTreeRoot == null) {
                    return;
                }
                parentTreeEntity = this.objectRepositoryTreeRoot;
            }
            if ((dialog = new NewTestObjectDialog(parentShell, parentFolderEntity = (FolderEntity)parentTreeEntity.getObject(), suggestedName = (toController = ObjectRepositoryController.getInstance()).getAvailableWebElementName(parentFolderEntity, this.newDefaultName))).open() != 0) {
                return;
            }
            WebElementEntity webElement = toController.saveNewTestObject((WebElementEntity)dialog.getEntity());
            if (webElement == null) {
                MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_OBJ);
                return;
            }
            Trackings.trackCreatingObject((String)"testObject");
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new WebElementTreeEntity(webElement, parentTreeEntity));
            this.eventBroker.post("TESTOBJECT/OPEN", (Object)webElement);
        }
        catch (FilePathTooLongException e) {
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_OBJ);
        }
    }

    public static ITreeEntity getParentTreeEntity(Object[] selectedObjects) throws Exception {
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ITreeEntity) {
                if (((ITreeEntity)object).getObject() instanceof FolderEntity) {
                    FolderEntity folder = (FolderEntity)((ITreeEntity)object).getObject();
                    if (folder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                        return (ITreeEntity)object;
                    }
                } else if (((ITreeEntity)object).getObject() instanceof WebElementEntity) {
                    return ((ITreeEntity)object).getParent();
                }
            }
            ++n2;
        }
        return null;
    }

    @Inject
    @Optional
    private void catchObjectTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            for (Object o : treeEntities) {
                FolderEntity folder;
                Object entityObject = ((ITreeEntity)o).getObject();
                if (!(entityObject instanceof FolderEntity) || (folder = (FolderEntity)entityObject).getFolderType() != FolderEntity.FolderType.WEBELEMENT) continue;
                this.objectRepositoryTreeRoot = (FolderTreeEntity)o;
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

