/*
 * Decompiled with CFR 0.152.
 */
package src.main.scala;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.jblas.DoubleMatrix;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class MFDataGenerator$ {
    public static final MFDataGenerator$ MODULE$;

    static {
        new MFDataGenerator$();
    }

    public void main(String[] args) {
        if (args.length < 1) {
            Predef$.MODULE$.println((Object)"Usage: MFDataGenerator <outputDir> [m] [n] [rank] [trainSampFact] [noise] [sigma] [test] [testSampFact] [numPar]");
            System.exit(1);
        }
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        String outputPath = args[0];
        int m = args.length > 1 ? new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt() : 100;
        int n = args.length > 2 ? new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt() : 100;
        int rank = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : 10;
        double trainSampFact = args.length > 4 ? new StringOps(Predef$.MODULE$.augmentString(args[4])).toDouble() : 1.0;
        boolean noise = args.length > 5 ? new StringOps(Predef$.MODULE$.augmentString(args[5])).toBoolean() : false;
        double sigma = args.length > 6 ? new StringOps(Predef$.MODULE$.augmentString(args[6])).toDouble() : 0.1;
        boolean test = args.length > 7 ? new StringOps(Predef$.MODULE$.augmentString(args[7])).toBoolean() : false;
        double testSampFact = args.length > 8 ? new StringOps(Predef$.MODULE$.augmentString(args[8])).toDouble() : 0.1;
        int defPar = System.getProperty("spark.default.parallelism") == null ? 2 : new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.default.parallelism"))).toInt();
        int numPar = args.length > 9 ? new StringOps(Predef$.MODULE$.augmentString(args[9])).toInt() : defPar;
        SparkConf conf = new SparkConf().setAppName("MFDataGenerator");
        SparkContext sc = new SparkContext(conf);
        DoubleMatrix A = DoubleMatrix.randn((int)m, (int)rank);
        DoubleMatrix B = DoubleMatrix.randn((int)rank, (int)n);
        double z = 1.0 / package$.MODULE$.sqrt(package$.MODULE$.sqrt((double)rank));
        A.mmuli(z);
        B.mmuli(z);
        DoubleMatrix fullData = A.mmul(B);
        int df = rank * (m + n - rank);
        int sampSize = (int)package$.MODULE$.min(package$.MODULE$.round(trainSampFact * (double)df), package$.MODULE$.round(0.99 * (double)m * (double)n));
        Random rand = new Random();
        int mn = m * n;
        RDD my_rdd = sc.makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), mn), numPar, ClassTag$.MODULE$.Int());
        my_rdd.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD trainData = my_rdd.map((Function1)new Serializable(fullData){
            public static final long serialVersionUID = 0L;
            private final DoubleMatrix fullData$1;

            public final Tuple3<Object, Object, Object> apply(int x) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.fullData$1.indexRows(x - 1)), (Object)BoxesRunTime.boxToInteger((int)this.fullData$1.indexColumns(x - 1)), (Object)BoxesRunTime.boxToDouble((double)this.fullData$1.get(x - 1)));
            }
            {
                this.fullData$1 = fullData$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        Object object = noise ? trainData.map((Function1)new Serializable(sigma, rand){
            public static final long serialVersionUID = 0L;
            private final double sigma$1;
            private final Random rand$1;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple3(x._1(), x._2(), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)x._3()) + this.rand$1.nextGaussian() * this.sigma$1)));
            }
            {
                this.sigma$1 = sigma$1;
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)) : BoxedUnit.UNIT;
        trainData.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<Object, Object, Object> x) {
                return new StringBuilder().append(BoxesRunTime.unboxToInt((Object)x._1())).append((Object)",").append(x._2()).append((Object)",").append(x._3()).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outputPath);
        sc.stop();
    }

    private MFDataGenerator$() {
        MODULE$ = this;
    }
}

