/*
 * Decompiled with CFR 0.152.
 */
package MatrixFactorization.src.main.java;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import scala.Tuple2;

public class MFApp {
    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("usage: <input> <output> <rank> <maxIterations> <lambda> <storageLevel>");
            System.exit(0);
        }
        String input = args[0];
        String output = args[1];
        int rank = Integer.parseInt(args[2]);
        int numIterations = Integer.parseInt(args[3]);
        double lambda = Double.parseDouble(args[4]);
        String storage_level = args[5];
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        SparkConf conf = new SparkConf().setAppName("MFApp Example");
        JavaSparkContext sc = new JavaSparkContext(conf);
        long start = System.currentTimeMillis();
        JavaRDD data = sc.textFile(input);
        JavaRDD ratings = data.map((Function)new Function<String, Rating>(){

            public Rating call(String s) {
                String[] sarray = s.split(",");
                return new Rating(Integer.parseInt(sarray[0]), Integer.parseInt(sarray[1]), Double.parseDouble(sarray[2]));
            }
        });
        if (storage_level.equals("MEMORY_AND_DISK_SER")) {
            ratings.persist(StorageLevel.MEMORY_AND_DISK_SER());
        } else if (storage_level.equals("MEMORY_AND_DISK")) {
            ratings.persist(StorageLevel.MEMORY_AND_DISK());
        } else {
            ratings.cache();
        }
        RDD parsed_data = JavaRDD.toRDD((JavaRDD)ratings);
        if (storage_level.equals("MEMORY_AND_DISK_SER")) {
            parsed_data.persist(StorageLevel.MEMORY_AND_DISK_SER());
        } else if (storage_level.equals("MEMORY_AND_DISK")) {
            parsed_data.persist(StorageLevel.MEMORY_AND_DISK());
        } else {
            parsed_data.cache();
        }
        double loadTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        MatrixFactorizationModel model = ALS.train((RDD)parsed_data, (int)rank, (int)numIterations, (double)lambda);
        double trainingTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        JavaRDD userProducts = ratings.map((Function)new Function<Rating, Tuple2<Object, Object>>(){

            public Tuple2<Object, Object> call(Rating r) {
                return new Tuple2((Object)r.user(), (Object)r.product());
            }
        });
        if (storage_level.equals("MEMORY_AND_DISK_SER")) {
            userProducts.persist(StorageLevel.MEMORY_AND_DISK_SER());
        } else if (storage_level.equals("MEMORY_AND_DISK")) {
            userProducts.persist(StorageLevel.MEMORY_AND_DISK());
        } else {
            userProducts.cache();
        }
        JavaPairRDD predictions = JavaPairRDD.fromJavaRDD((JavaRDD)model.predict(JavaRDD.toRDD((JavaRDD)userProducts)).toJavaRDD().map((Function)new Function<Rating, Tuple2<Tuple2<Integer, Integer>, Double>>(){

            public Tuple2<Tuple2<Integer, Integer>, Double> call(Rating r) {
                return new Tuple2((Object)new Tuple2((Object)r.user(), (Object)r.product()), (Object)r.rating());
            }
        }));
        JavaRDD ratesAndPreds = JavaPairRDD.fromJavaRDD((JavaRDD)ratings.map((Function)new Function<Rating, Tuple2<Tuple2<Integer, Integer>, Double>>(){

            public Tuple2<Tuple2<Integer, Integer>, Double> call(Rating r) {
                return new Tuple2((Object)new Tuple2((Object)r.user(), (Object)r.product()), (Object)r.rating());
            }
        })).join(predictions).values();
        double MSE = JavaDoubleRDD.fromRDD((RDD)ratesAndPreds.map((Function)new Function<Tuple2<Double, Double>, Object>(){

            public Object call(Tuple2<Double, Double> pair) {
                Double err = (Double)pair._1() - (Double)pair._2();
                return err * err;
            }
        }).rdd()).mean();
        double testTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.printf("{\"loadTime\":%.3f,\"trainingTime\":%.3f,\"testTime\":%.3f}\n", loadTime, trainingTime, testTime);
        System.out.println("Mean Squared Error = " + MSE);
        sc.stop();
    }
}

