/*
 * Decompiled with CFR 0.152.
 */
package LogisticRegression.src.main.java;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import scala.Tuple2;

public class LogisticRegressionApp {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("usage: <input> <output>  <maxIterations> <StorageLevel> ");
            System.exit(0);
        }
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        String input = args[0];
        String output = args[1];
        int numIterations = Integer.parseInt(args[2]);
        String sl = args[3];
        SparkConf conf = new SparkConf().setAppName("LogisticRegressionApp Example");
        JavaSparkContext sc = new JavaSparkContext(conf);
        conf.registerKryoClasses(new Class[]{LogisticRegressionApp.class});
        long start = System.currentTimeMillis();
        JavaRDD data = sc.textFile(input);
        JavaRDD parsedData = data.map((Function)new Function<String, LabeledPoint>(){

            public LabeledPoint call(String line) {
                return LabeledPoint.parse((String)line);
            }
        });
        RDD parsedRDD_Data = JavaRDD.toRDD((JavaRDD)parsedData);
        if (sl.equals("MEMORY_AND_DISK_SER")) {
            parsedRDD_Data.persist(StorageLevel.MEMORY_AND_DISK_SER());
        } else {
            parsedRDD_Data.persist(StorageLevel.MEMORY_AND_DISK());
        }
        double loadTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        final LogisticRegressionModel model = LogisticRegressionWithSGD.train((RDD)parsedRDD_Data, (int)numIterations);
        double trainingTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        JavaRDD valuesAndPreds = parsedData.map((Function)new Function<LabeledPoint, Tuple2<Double, Double>>(){

            public Tuple2<Double, Double> call(LabeledPoint point) {
                double prediction = model.predict(point.features());
                return new Tuple2((Object)prediction, (Object)point.label());
            }
        });
        Double MSE = new JavaDoubleRDD(valuesAndPreds.map((Function)new Function<Tuple2<Double, Double>, Object>(){

            public Object call(Tuple2<Double, Double> pair) {
                return Math.pow((Double)pair._1() - (Double)pair._2(), 2.0);
            }
        }).rdd()).mean();
        double testTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.printf("{\"loadTime\":%.3f,\"trainingTime\":%.3f,\"testTime\":%.3f}\n", loadTime, trainingTime, testTime);
        System.out.println("training Mean Squared Error = " + MSE);
        sc.stop();
    }
}

