/*
 * Decompiled with CFR 0.152.
 */
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.util.KMeansDataGenerator;
import org.apache.spark.rdd.RDD;

public class KmeansDataGenJava {
    public static void main(String[] args) {
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        if (args.length < 5) {
            System.out.println("usage: <output> <numPoints> <numClusters> <dimenstion> <scaling factor> [numPar]");
            System.exit(0);
        }
        String output = args[0];
        int numPoint = Integer.parseInt(args[1]);
        int numCluster = Integer.parseInt(args[2]);
        int numDim = Integer.parseInt(args[3]);
        double scaling = Double.parseDouble(args[4]);
        int numPar = args.length > 5 ? Integer.parseInt(args[5]) : (System.getProperty("spark.default.parallelism") != null ? Integer.parseInt(System.getProperty("spark.default.parallelism")) : 2);
        SparkConf conf = new SparkConf().setAppName("Kmeans data generation (Java version)");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        RDD data = KMeansDataGenerator.generateKMeansRDD((SparkContext)jsc.sc(), (int)numPoint, (int)numCluster, (int)numDim, (double)scaling, (int)numPar);
        JavaRDD tmpdata = data.toJavaRDD();
        JavaRDD parsedData = tmpdata.map((Function)new Function<double[], String>(){

            public String call(double[] s) {
                String sarray = "";
                for (int i = 0; i < s.length; ++i) {
                    sarray = sarray + s[i] + " ";
                }
                return sarray;
            }
        });
        parsedData.saveAsTextFile(output);
        jsc.stop();
    }
}

