/*
 * Decompiled with CFR 0.152.
 */
package src.main.scala;

import com.google.common.primitives.UnsignedBytes;
import java.util.Comparator;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import src.main.java.Unsigned16;
import src.main.scala.TeraInputFormat;

public final class TeraValidate$ {
    public static final TeraValidate$ MODULE$;

    static {
        new TeraValidate$();
    }

    public void main(String[] args) {
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        if (args.length < 1) {
            Predef$.MODULE$.println((Object)"Usage:");
            Predef$.MODULE$.println((Object)"DRIVER_MEMORY=[mem] spark-submit com.github.ehiggs.spark.terasort.TeraValidate spark-terasort-1.0-SNAPSHOT-with-dependencies.jar [input-directory]");
            Predef$.MODULE$.println((Object)" ");
            Predef$.MODULE$.println((Object)"Example:");
            Predef$.MODULE$.println((Object)"DRIVER_MEMORY=50g spark-submit com.github.ehiggs.spark.terasort.TeraValidate spark-terasort-1.0-SNAPSHOT-with-dependencies.jar file:///scratch/username/terasort_in ");
            System.exit(0);
        }
        String inputFile = args[0];
        SparkConf conf = new SparkConf().set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TeraValidate"})).s((Seq)Nil$.MODULE$));
        SparkContext sc = new SparkContext(conf);
        RDD dataset = sc.newAPIHadoopFile(inputFile, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), ClassTag$.MODULE$.apply(TeraInputFormat.class));
        this.validate(sc, (RDD<Tuple2<byte[], byte[]>>)dataset);
    }

    public void validate(SparkContext sc, RDD<Tuple2<byte[], byte[]>> dataset) {
        RDD output = dataset.mapPartitions((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple3<Unsigned16, byte[], byte[]>> apply(Iterator<Tuple2<byte[], byte[]>> iter) {
                Unsigned16 sum = new Unsigned16();
                Unsigned16 checksum = new Unsigned16();
                PureJavaCrc32 crc32 = new PureJavaCrc32();
                byte[] min = new byte[10];
                byte[] max = new byte[10];
                Comparator cmp = UnsignedBytes.lexicographicalComparator();
                long pos = 0L;
                byte[] prev = new byte[10];
                while (iter.hasNext()) {
                    byte[] key = (byte[])((Tuple2)iter.next())._1();
                    Predef$.MODULE$.assert(cmp.compare(key, prev) >= 0);
                    crc32.reset();
                    crc32.update(key, 0, key.length);
                    checksum.set(crc32.getValue());
                    sum.add(checksum);
                    if (pos == 0L) {
                        Predef$.MODULE$.byteArrayOps(key).copyToArray((Object)min, 0, 10);
                    }
                    ++pos;
                    prev = key;
                }
                Predef$.MODULE$.byteArrayOps(prev).copyToArray((Object)max, 0, 10);
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)sum, (Object)min, (Object)max)}));
            }
        }, true, ClassTag$.MODULE$.apply(Tuple3.class));
        Tuple3[] checksumOutput = (Tuple3[])output.collect();
        Comparator cmp = UnsignedBytes.lexicographicalComparator();
        Unsigned16 sum = new Unsigned16();
        long numRecords = dataset.count();
        Predef$.MODULE$.refArrayOps((Object[])checksumOutput).foreach((Function1)new Serializable(sum){
            public static final long serialVersionUID = 0L;
            private final Unsigned16 sum$1;

            public final void apply(Tuple3<Unsigned16, byte[], byte[]> x0$1) {
                Tuple3<Unsigned16, byte[], byte[]> tuple3 = x0$1;
                if (tuple3 != null) {
                    Unsigned16 partSum = (Unsigned16)tuple3._1();
                    this.sum$1.add(partSum);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                this.sum$1 = sum$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"num records: ").append((Object)BoxesRunTime.boxToLong((long)numRecords)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"checksum: ").append((Object)sum.toString()).toString());
        ObjectRef lastMax = new ObjectRef((Object)new byte[10]);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])checksumOutput).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Unsigned16, byte[], byte[]> apply(Tuple3<Unsigned16, byte[], byte[]> x0$2) {
                Tuple3<Unsigned16, byte[], byte[]> tuple3 = x0$2;
                if (tuple3 != null) {
                    Unsigned16 partSum = (Unsigned16)tuple3._1();
                    byte[] min = (byte[])tuple3._2();
                    byte[] max = (byte[])tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)partSum, min.clone(), max.clone());
                    return tuple32;
                }
                throw new MatchError(tuple3);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(cmp, lastMax){
            public static final long serialVersionUID = 0L;
            private final Comparator cmp$1;
            private final ObjectRef lastMax$1;

            public final void apply(Tuple2<Tuple3<Unsigned16, byte[], byte[]>, Object> x0$3) {
                Tuple2<Tuple3<Unsigned16, byte[], byte[]>, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (tuple3 != null) {
                        byte[] min = (byte[])tuple3._2();
                        byte[] max = (byte[])tuple3._3();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastMax"})).s((Seq)Nil$.MODULE$)).append(Predef$.MODULE$.byteArrayOps((byte[])this.lastMax$1.elem).toSeq().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(byte x) {
                                return x < 0 ? 256 + x : x;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toString());
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"min "})).s((Seq)Nil$.MODULE$)).append(Predef$.MODULE$.byteArrayOps(min).toSeq().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(byte x) {
                                return x < 0 ? 256 + x : x;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toString());
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max "})).s((Seq)Nil$.MODULE$)).append(Predef$.MODULE$.byteArrayOps(max).toSeq().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(byte x) {
                                return x < 0 ? 256 + x : x;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toString());
                        Predef$.MODULE$.assert(this.cmp$1.compare(min, max) <= 0, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "min >= max";
                            }
                        });
                        Predef$.MODULE$.assert(this.cmp$1.compare((byte[])this.lastMax$1.elem, min) <= 0, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "current partition min < last partition max";
                            }
                        });
                        this.lastMax$1.elem = max;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.cmp$1 = cmp$1;
                this.lastMax$1 = lastMax$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"num records: ").append((Object)BoxesRunTime.boxToLong((long)numRecords)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"checksum: ").append((Object)sum.toString()).toString());
        Predef$.MODULE$.println((Object)"partitions are properly sorted");
    }

    private TeraValidate$() {
        MODULE$ = this;
    }
}

