/*
 * Decompiled with CFR 0.152.
 */
package src.main.java;

import org.json.simple.JSONObject;

class Task {
    long stime = 0L;
    long ftime = 0L;
    long inputbytes = 0L;
    long inputbytes_mem = 0L;
    long inputbytes_disk = 0L;
    long inputbytes_hadoop = 0L;
    long inputbytes_network = 0L;
    long shuffle_read = 0L;
    long shuffle_write = 0L;
    long taskevt = 0L;
    long taskevt_nonempty = 0L;
    long shuffle_task_num = 0L;
    long shuffle_task_time = 0L;
    long result_task_num = 0L;
    long result_task_time = 0L;
    long result_size = 0L;

    Task() {
    }

    public void parseJSON(JSONObject obj) {
        JSONObject shuffleWritemetric;
        JSONObject shuffleReadmetric;
        Long val;
        String method;
        JSONObject taskmetrics;
        ++this.taskevt;
        String tasktype = (String)obj.get((Object)"Task Type");
        JSONObject info = (JSONObject)obj.get((Object)"Task Info");
        if (info != null) {
            Long id = (Long)info.get((Object)"Stage ID");
            Long st = (Long)info.get((Object)"Launch Time");
            Long ft = (Long)info.get((Object)"Finish Time");
            if (ft - st > 0L) {
                ++this.taskevt_nonempty;
            }
            if (tasktype.equals("ResultTask")) {
                this.result_task_time += ft - st;
                ++this.result_task_num;
            } else if (tasktype.equals("ShuffleMapTask")) {
                this.shuffle_task_time += ft - st;
                ++this.shuffle_task_num;
            }
        }
        if ((taskmetrics = (JSONObject)obj.get((Object)"Task Metrics")) == null) {
            return;
        }
        JSONObject inputmetric = (JSONObject)taskmetrics.get((Object)"Input Metrics");
        if (inputmetric != null && (method = (String)inputmetric.get((Object)"Data Read Method")) != null) {
            val = (Long)inputmetric.get((Object)"Bytes Read");
            this.inputbytes += val.longValue();
            if (method.equals("Hadoop")) {
                this.inputbytes_hadoop += val.longValue();
            } else if (method.equals("Disk")) {
                this.inputbytes_disk += val.longValue();
            } else if (method.equals("Memory")) {
                this.inputbytes_mem += val.longValue();
            } else if (method.equals("Network")) {
                this.inputbytes_network += val.longValue();
            }
        }
        if ((shuffleReadmetric = (JSONObject)taskmetrics.get((Object)"Shuffle Read Metrics")) != null) {
            val = (Long)shuffleReadmetric.get((Object)"Remote Bytes Read");
            this.shuffle_read += val.longValue();
        }
        if ((shuffleWritemetric = (JSONObject)taskmetrics.get((Object)"Shuffle Write Metrics")) != null) {
            Long val2 = (Long)shuffleWritemetric.get((Object)"Shuffle Bytes Written");
            this.shuffle_write += val2.longValue();
        }
    }

    public void Task() {
        this.inputbytes = 0L;
        this.shuffle_read = 0L;
        this.shuffle_write = 0L;
        this.taskevt = 0L;
    }

    public void printVal() {
        double tot_task_t = this.shuffle_task_time + this.result_task_time;
        double stask_percent = (double)this.shuffle_task_time / tot_task_t;
        double rtask_percent = (double)this.result_task_time / tot_task_t;
        double tot_task_n = this.shuffle_task_num + this.result_task_num;
        double staskn_percent = (double)this.shuffle_task_num / tot_task_n;
        double rtaskn_percent = (double)this.result_task_num / tot_task_n;
        System.out.printf("inputbytes_tot %d M: %.2f G, hadoop %d M: %.2f G,mem %d M: %.2f G,disk %d M: %.2f G,network %d M: %.2f G, taskNum %d ,taskNoEmptyNum %d ;shuffle read %d M: %.2f G; write %d M; %.2f G;", this.inputbytes >> 20, (double)(this.inputbytes >> 20) / 1024.0, this.inputbytes_hadoop >> 20, (double)(this.inputbytes_hadoop >> 20) / 1024.0, this.inputbytes_mem >> 20, (double)(this.inputbytes_mem >> 20) / 1024.0, this.inputbytes_disk >> 20, (double)(this.inputbytes_disk >> 20) / 1024.0, this.inputbytes_network >> 20, (double)(this.inputbytes_network >> 20) / 1024.0, this.taskevt, this.taskevt_nonempty, this.shuffle_read >> 20, (double)(this.shuffle_read >> 20) / 1024.0, this.shuffle_write >> 20, (double)(this.shuffle_write >> 20) / 1024.0);
        System.out.printf(" time:shuffle:result %.2f : %.2f min; %.2f : %.2f", (double)this.shuffle_task_time / 1000.0 / 60.0, (double)this.result_task_time / 1000.0 / 60.0, stask_percent, rtask_percent);
        System.out.printf(" num:shuffle:result %d : %d ; %.2f : %.2f", this.shuffle_task_num, this.result_task_num, staskn_percent, rtaskn_percent);
        System.out.println();
    }
}

