/*
 * Decompiled with CFR 0.152.
 */
package src.main.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import src.main.java.App;
import src.main.java.Stage;
import src.main.java.Task;

public class GetSparkMetrics {
    public static void main(String[] args) {
        try {
            String line;
            if (args.length < 1) {
                System.out.println("usage: inputfile ");
            }
            String inputFilePath = args[0];
            File file = new File(inputFilePath);
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            Task task = new Task();
            Stage stage = new Stage();
            App app = new App();
            JSONParser parser = new JSONParser();
            while ((line = br.readLine()) != null) {
                JSONObject obj = (JSONObject)parser.parse(line);
                String event = (String)obj.get((Object)"Event");
                if (event.contains("TaskEnd")) {
                    task.parseJSON(obj);
                    continue;
                }
                if (event.contains("StageCompleted")) {
                    stage.parseJSON(obj);
                    continue;
                }
                if (event.contains("ApplicationStart")) {
                    app.parseJSON(obj, Boolean.TRUE);
                    continue;
                }
                if (!event.contains("ApplicationEnd")) continue;
                app.parseJSON(obj, Boolean.FALSE);
            }
            task.printVal();
            stage.printVal();
            app.printVal();
            br.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

