/*
 * Decompiled with CFR 0.152.
 */
package SVM.src.main.java;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import scala.Tuple2;

public class SVMApp {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("usage: <input> <output>  <maxIterations> <StorageLevel>");
            System.exit(0);
        }
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        String input = args[0];
        String output = args[1];
        int numIterations = Integer.parseInt(args[2]);
        String storage_level = args[3];
        SparkConf conf = new SparkConf().setAppName("SVM Classifier Example");
        JavaSparkContext sc = new JavaSparkContext(conf);
        long start = System.currentTimeMillis();
        JavaRDD tmpdata = sc.textFile(input);
        JavaRDD data = tmpdata.map((Function)new Function<String, LabeledPoint>(){

            public LabeledPoint call(String line) {
                return LabeledPoint.parse((String)line);
            }
        });
        JavaRDD training = data.sample(false, 0.9, 11L);
        if (storage_level.equals("MEMORY_AND_DISK_SER")) {
            training.persist(StorageLevel.MEMORY_AND_DISK_SER());
        } else {
            training.cache();
        }
        System.out.println("test data ");
        JavaRDD test = data.subtract(training);
        double loadTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.println("Train model ");
        start = System.currentTimeMillis();
        final SVMModel model = SVMWithSGD.train((RDD)training.rdd(), (int)numIterations);
        double trainingTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        model.clearThreshold();
        System.out.println("predict score and labels ");
        JavaRDD scoreAndLabels = test.map((Function)new Function<LabeledPoint, Tuple2<Object, Object>>(){

            public Tuple2<Object, Object> call(LabeledPoint p) {
                Double score = model.predict(p.features());
                return new Tuple2((Object)score, (Object)p.label());
            }
        });
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(JavaRDD.toRDD((JavaRDD)scoreAndLabels));
        double auROC = metrics.areaUnderROC();
        double testTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.printf("{\"loadTime\":%.3f,\"trainingTime\":%.3f,\"testTime\":%.3f}\n", loadTime, trainingTime, testTime);
        System.out.println("Area under ROC = " + auROC);
        sc.stop();
    }
}

