/*
 * Decompiled with CFR 0.152.
 */
package src.main.scala;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import src.main.java.Random16;
import src.main.java.Unsigned16;
import src.main.scala.TeraInputFormat$;
import src.main.scala.TeraOutputFormat;

public final class terasortDataGen$ {
    public static final terasortDataGen$ MODULE$;

    static {
        new terasortDataGen$();
    }

    public void main(String[] args) {
        RDD dataset;
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        if (args.length < 3) {
            System.out.println("usage: <numberOfRecords> <output> <numPar>");
            System.exit(0);
        }
        long outputSizeInBytes = this.sizeStrToBytes(args[0]);
        String outputFile = args[1];
        String size = this.sizeToSizeStr(outputSizeInBytes);
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TeraGen (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{size})));
        SparkContext sc = new SparkContext(conf);
        int parts = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        long recordsPerPartition = outputSizeInBytes / 100L / (long)parts;
        Predef$.MODULE$.println((Object)"===========================================================================");
        Predef$.MODULE$.println((Object)"===========================================================================");
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{size})));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total number of records: "})).s((Seq)Nil$.MODULE$)).append((Object)args[0]).toString());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of output partitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)parts)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of records/ partition:   ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)recordsPerPartition)})));
        Predef$.MODULE$.println((Object)"===========================================================================");
        Predef$.MODULE$.println((Object)"===========================================================================");
        Predef$.MODULE$.assert(recordsPerPartition < Integer.MAX_VALUE, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"records per partition > ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)}));
            }
        });
        RDD qual$1 = sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), parts), parts, ClassTag$.MODULE$.Int());
        Serializable x$1 = new Serializable(recordsPerPartition){
            public static final long serialVersionUID = 0L;
            private final long recordsPerPartition$1;

            public final Iterator<Tuple2<byte[], byte[]>> apply(int x0$1, Iterator<Object> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), x1$1);
                if (tuple2 != null) {
                    int index = tuple2._1$mcI$sp();
                    Unsigned16 one = new Unsigned16(1L);
                    Unsigned16 firstRecordNumber = new Unsigned16((long)index * this.recordsPerPartition$1);
                    Unsigned16 recordsToGenerate = new Unsigned16(this.recordsPerPartition$1);
                    Unsigned16 recordNumber = new Unsigned16(firstRecordNumber);
                    Unsigned16 lastRecordNumber = new Unsigned16(firstRecordNumber);
                    lastRecordNumber.add(recordsToGenerate);
                    Unsigned16 rand = Random16.skipAhead(firstRecordNumber);
                    byte[] rowBytes = new byte[TeraInputFormat$.MODULE$.RECORD_LEN()];
                    byte[] key = new byte[TeraInputFormat$.MODULE$.KEY_LEN()];
                    byte[] value = new byte[TeraInputFormat$.MODULE$.VALUE_LEN()];
                    Iterator iterator = package$.MODULE$.Iterator().tabulate((int)this.recordsPerPartition$1, (Function1)new Serializable(this, one, recordNumber, rand, rowBytes, key, value){
                        public static final long serialVersionUID = 0L;
                        private final Unsigned16 one$1;
                        private final Unsigned16 recordNumber$1;
                        private final Unsigned16 rand$1;
                        private final byte[] rowBytes$1;
                        private final byte[] key$1;
                        private final byte[] value$1;

                        public final Tuple2<byte[], byte[]> apply(int offset) {
                            Random16.nextRand(this.rand$1);
                            terasortDataGen$.MODULE$.generateRecord(this.rowBytes$1, this.rand$1, this.recordNumber$1);
                            this.recordNumber$1.add(this.one$1);
                            Predef$.MODULE$.byteArrayOps(this.rowBytes$1).copyToArray((Object)this.key$1, 0, TeraInputFormat$.MODULE$.KEY_LEN());
                            Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(this.rowBytes$1).takeRight(TeraInputFormat$.MODULE$.VALUE_LEN())).copyToArray((Object)this.value$1, 0, TeraInputFormat$.MODULE$.VALUE_LEN());
                            return new Tuple2((Object)this.key$1, (Object)this.value$1);
                        }
                        {
                            this.one$1 = one$1;
                            this.recordNumber$1 = recordNumber$1;
                            this.rand$1 = rand$1;
                            this.rowBytes$1 = rowBytes$1;
                            this.key$1 = key$1;
                            this.value$1 = value$1;
                        }
                    });
                    return iterator;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.recordsPerPartition$1 = recordsPerPartition$1;
            }
        };
        boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
        RDD x$3 = dataset = qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$4 = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE));
        ClassTag x$5 = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE));
        Null$ x$6 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$3);
        RDD$.MODULE$.rddToPairRDDFunctions(x$3, x$4, x$5, null).saveAsNewAPIHadoopFile(outputFile, ClassTag$.MODULE$.apply(TeraOutputFormat.class));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Number of records written: ").append((Object)BoxesRunTime.boxToLong((long)dataset.count())).toString());
    }

    public long sizeStrToBytes(String str) {
        String lower = str.toLowerCase();
        return lower.endsWith("k") ? new StringOps(Predef$.MODULE$.augmentString(lower.substring(0, lower.length() - 1))).toLong() * 1000L * 100L : (lower.endsWith("m") ? new StringOps(Predef$.MODULE$.augmentString(lower.substring(0, lower.length() - 1))).toLong() * 1000L * 1000L * 100L : (lower.endsWith("g") ? new StringOps(Predef$.MODULE$.augmentString(lower.substring(0, lower.length() - 1))).toLong() * 1000L * 1000L * 1000L * 100L : (lower.endsWith("t") ? new StringOps(Predef$.MODULE$.augmentString(lower.substring(0, lower.length() - 1))).toLong() * 1000L * 1000L * 1000L * 1000L * 100L : new StringOps(Predef$.MODULE$.augmentString(lower)).toLong() * 100L)));
    }

    public String sizeToSizeStr(long size) {
        long kbScale = 1000L;
        long mbScale = 1000L * kbScale;
        long gbScale = 1000L * mbScale;
        long tbScale = 1000L * gbScale;
        return size > tbScale ? new StringBuilder().append(size / tbScale).append((Object)"TB").toString() : (size > gbScale ? new StringBuilder().append(size / gbScale).append((Object)"GB").toString() : (size > mbScale ? new StringBuilder().append(size / mbScale).append((Object)"MB").toString() : (size > kbScale ? new StringBuilder().append(size / kbScale).append((Object)"KB").toString() : new StringBuilder().append(size).append((Object)"B").toString())));
    }

    public void generateRecord(byte[] recBuf, Unsigned16 rand, Unsigned16 recordNumber) {
        int i;
        for (i = 0; i < 10; ++i) {
            recBuf[i] = rand.getByte(i);
        }
        recBuf[10] = (byte)0;
        recBuf[11] = (byte)17;
        for (i = 0; i < 32; ++i) {
            recBuf[12 + i] = (byte)recordNumber.getHexDigit(i);
        }
        recBuf[44] = (byte)136;
        recBuf[45] = (byte)153;
        recBuf[46] = (byte)170;
        recBuf[47] = (byte)187;
        for (i = 0; i < 12; ++i) {
            byte v;
            recBuf[48 + i * 4] = v = (byte)rand.getHexDigit(20 + i);
            recBuf[49 + i * 4] = v;
            recBuf[50 + i * 4] = v;
            recBuf[51 + i * 4] = v;
        }
        recBuf[96] = (byte)204;
        recBuf[97] = (byte)221;
        recBuf[98] = (byte)238;
        recBuf[99] = (byte)255;
    }

    private terasortDataGen$() {
        MODULE$ = this;
    }
}

