/*
 * Decompiled with CFR 0.152.
 */
package src.main.scala;

import java.io.File;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import src.main.scala.MFMovieLens$;
import src.main.scala.MFMovieLens$$anonfun$main$1$;

public final class MFMovieLens$ {
    public static final MFMovieLens$ MODULE$;

    static {
        new MFMovieLens$();
    }

    public void main(String[] args) {
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        if (args.length != 3) {
            Predef$.MODULE$.println((Object)"Usage: /path/to/spark/bin/spark-submit --driver-memory 2g --class MovieLensALS target/scala-*/movielens-als-ssembly-*.jar movieLensHomeDir personalRatingsFile");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        SparkConf conf = new SparkConf().setAppName("MF MovieLens");
        SparkContext sc = new SparkContext(conf);
        Seq<Rating> myRatings = this.loadRatings(args[1]);
        RDD myRatingsRDD = sc.parallelize(myRatings, 1, ClassTag$.MODULE$.apply(Rating.class));
        String movieLensHomeDir = args[0];
        int numPartitions = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        RDD ratings = sc.textFile(new File(movieLensHomeDir, "ratings.dat").toString(), sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Rating> apply(String line) {
                String[] fields = line.split("::");
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(new StringOps(Predef$.MODULE$.augmentString(fields[3])).toLong() % 10L)), (Object)new Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        long numRatings = ratings.count();
        long numUsers = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Rating> x$1) {
                return ((Rating)x$1._2()).user();
            }
        }, ClassTag$.MODULE$.Int()).distinct().count();
        long numMovies = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Rating> x$2) {
                return ((Rating)x$2._2()).product();
            }
        }, ClassTag$.MODULE$.Int()).distinct().count();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Got ").append((Object)BoxesRunTime.boxToLong((long)numRatings)).append((Object)" ratings from ").append((Object)BoxesRunTime.boxToLong((long)numUsers)).append((Object)" users on ").append((Object)BoxesRunTime.boxToLong((long)numMovies)).append((Object)" movies.").toString());
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(ratings.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Rating> x) {
                return x._1$mcJ$sp() < 6L;
            }
        }), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Rating.class), (Ordering)Ordering.Long$.MODULE$).values().union(myRatingsRDD);
        int x$7 = numPartitions;
        Ordering x$8 = qual$1.repartition$default$2(x$7);
        RDD training = qual$1.repartition(x$7, x$8).cache();
        RDD qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(ratings.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Rating> x) {
                return x._1$mcJ$sp() >= 6L && x._1$mcJ$sp() < 8L;
            }
        }), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Rating.class), (Ordering)Ordering.Long$.MODULE$).values();
        int x$9 = numPartitions;
        Ordering x$10 = qual$2.repartition$default$2(x$9);
        RDD validation = qual$2.repartition(x$9, x$10).cache();
        RDD test = RDD$.MODULE$.rddToPairRDDFunctions(ratings.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Rating> x) {
                return x._1$mcJ$sp() >= 8L;
            }
        }), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Rating.class), (Ordering)Ordering.Long$.MODULE$).values().cache();
        long numTraining = training.count();
        long numValidation = validation.count();
        long numTest = test.count();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Training: ").append((Object)BoxesRunTime.boxToLong((long)numTraining)).append((Object)", validation: ").append((Object)BoxesRunTime.boxToLong((long)numValidation)).append((Object)", test: ").append((Object)BoxesRunTime.boxToLong((long)numTest)).toString());
        List ranks = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 12}));
        List lambdas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1}));
        List numIters = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10}));
        ObjectRef bestModel = new ObjectRef((Object)None$.MODULE$);
        DoubleRef bestValidationRmse = new DoubleRef(Double.MAX_VALUE);
        IntRef bestRank = new IntRef(0);
        DoubleRef bestLambda = new DoubleRef(-1.0);
        IntRef bestNumIter = new IntRef(-1);
        ranks.foreach((Function1)new Serializable(numPartitions, training, validation, numValidation, lambdas, numIters, bestModel, bestValidationRmse, bestRank, bestLambda, bestNumIter){
            public static final long serialVersionUID = 0L;
            public final int numPartitions$1;
            public final RDD training$1;
            public final RDD validation$1;
            public final long numValidation$1;
            private final List lambdas$1;
            public final List numIters$1;
            public final ObjectRef bestModel$1;
            public final DoubleRef bestValidationRmse$1;
            public final IntRef bestRank$1;
            public final DoubleRef bestLambda$1;
            public final IntRef bestNumIter$1;

            public final void apply(int rank) {
                this.apply$mcVI$sp(rank);
            }

            public void apply$mcVI$sp(int rank) {
                this.lambdas$1.foreach((Function1)new Serializable(this, rank){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;
                    public final int rank$1;

                    public final void apply(double lambda) {
                        this.apply$mcVD$sp(lambda);
                    }

                    public void apply$mcVD$sp(double lambda) {
                        this.$outer.numIters$1.foreach((Function1)new Serializable(this, lambda){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$main$1$$anonfun$apply$mcVI$sp$1 $outer;
                            private final double lambda$1;

                            public final void apply(int numIter) {
                                this.apply$mcVI$sp(numIter);
                            }

                            public void apply$mcVI$sp(int numIter) {
                                MatrixFactorizationModel model = ALS$.MODULE$.train(this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().training$1, this.$outer.rank$1, numIter, this.lambda$1);
                                RDD$.MODULE$.rddToPairRDDFunctions(model.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new HashPartitioner(this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().numPartitions$1));
                                RDD$.MODULE$.rddToPairRDDFunctions(model.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new HashPartitioner(this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().numPartitions$1));
                                double validationRmse = MFMovieLens$.MODULE$.computeRmse(model, (RDD<Rating>)this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().validation$1, this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().numValidation$1);
                                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"RMSE (validation) = ").append((Object)BoxesRunTime.boxToDouble((double)validationRmse)).append((Object)" for the model trained with rank = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.rank$1)).append((Object)", lambda = ").append((Object)BoxesRunTime.boxToDouble((double)this.lambda$1)).append((Object)", and numIter = ").append((Object)BoxesRunTime.boxToInteger((int)numIter)).append((Object)".").toString());
                                if (validationRmse < this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().bestValidationRmse$1.elem) {
                                    this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().bestModel$1.elem = new Some((Object)model);
                                    this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().bestValidationRmse$1.elem = validationRmse;
                                    this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().bestRank$1.elem = this.$outer.rank$1;
                                    this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().bestLambda$1.elem = this.lambda$1;
                                    this.$outer.src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer().bestNumIter$1.elem = numIter;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.lambda$1 = lambda$1;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.main.1 src$main$scala$MFMovieLens$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rank$1 = rank$1;
                    }
                });
            }
            {
                this.numPartitions$1 = numPartitions$1;
                this.training$1 = training$1;
                this.validation$1 = validation$1;
                this.numValidation$1 = numValidation$1;
                this.lambdas$1 = lambdas$1;
                this.numIters$1 = numIters$1;
                this.bestModel$1 = bestModel$1;
                this.bestValidationRmse$1 = bestValidationRmse$1;
                this.bestRank$1 = bestRank$1;
                this.bestLambda$1 = bestLambda$1;
                this.bestNumIter$1 = bestNumIter$1;
            }
        });
        double testRmse = this.computeRmse((MatrixFactorizationModel)((Option)bestModel.elem).get(), (RDD<Rating>)test, numTest);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"The best model was trained with rank = ").append((Object)BoxesRunTime.boxToInteger((int)bestRank.elem)).append((Object)" and lambda = ").append((Object)BoxesRunTime.boxToDouble((double)bestLambda.elem)).append((Object)", and numIter = ").append((Object)BoxesRunTime.boxToInteger((int)bestNumIter.elem)).append((Object)", and its RMSE on the test set is ").append((Object)BoxesRunTime.boxToDouble((double)testRmse)).append((Object)".").toString());
        double meanRating = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(training.union(validation).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Rating x$3) {
                return x$3.rating();
            }
        }, ClassTag$.MODULE$.Double())).mean();
        double baselineRmse = package$.MODULE$.sqrt(RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(test.map((Function1)new Serializable(meanRating){
            public static final long serialVersionUID = 0L;
            private final double meanRating$1;

            public final double apply(Rating x) {
                return (this.meanRating$1 - x.rating()) * (this.meanRating$1 - x.rating());
            }
            {
                this.meanRating$1 = meanRating$1;
            }
        }, ClassTag$.MODULE$.Double())).mean());
        double improvement = (baselineRmse - testRmse) / baselineRmse * (double)100;
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"The best model improves the baseline by ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%1.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)improvement)}))).append((Object)"%.").toString());
        sc.stop();
    }

    public double computeRmse(MatrixFactorizationModel model, RDD<Rating> data, long n) {
        RDD predictions = model.predict(data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Rating x) {
                return new Tuple2.mcII.sp(x.user(), x.product());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        RDD predictionsAndRatings = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(predictions.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(Rating x) {
                return new Tuple2((Object)new Tuple2.mcII.sp(x.user(), x.product()), (Object)BoxesRunTime.boxToDouble((double)x.rating()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).join(data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(Rating x) {
                return new Tuple2((Object)new Tuple2.mcII.sp(x.user(), x.product()), (Object)BoxesRunTime.boxToDouble((double)x.rating()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).values();
        return package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)predictionsAndRatings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x) {
                return (x._1$mcD$sp() - x._2$mcD$sp()) * (x._1$mcD$sp() - x._2$mcD$sp());
            }
        }, ClassTag$.MODULE$.Double()).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$4, double x$5) {
                return this.apply$mcDDD$sp(x$4, x$5);
            }

            public double apply$mcDDD$sp(double x$4, double x$5) {
                return x$4 + x$5;
            }
        })) / (double)n);
    }

    public Seq<Rating> loadRatings(String path) {
        Iterator lines = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec()).getLines();
        Iterator ratings = lines.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Rating apply(String line) {
                String[] fields = line.split("::");
                return new Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble());
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Rating x$6) {
                return x$6.rating() > 0.0;
            }
        });
        if (ratings.isEmpty()) {
            throw scala.sys.package$.MODULE$.error("No ratings provided.");
        }
        return ratings.toSeq();
    }

    private MFMovieLens$() {
        MODULE$ = this;
    }
}

