/*
 * Decompiled with CFR 0.152.
 */
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.rdd.RDD;

public class KmeansAppJava {
    public static void main(String[] args) {
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        if (args.length < 5) {
            System.out.println("usage: <input> <output> <numClusters> <maxIterations> <runs> - optional");
            System.exit(0);
        }
        String input = args[0];
        String output = args[1];
        int K = Integer.parseInt(args[2]);
        int maxIterations = Integer.parseInt(args[3]);
        int runs = Integer.parseInt(args[4]);
        SparkConf conf = new SparkConf().setAppName("K-means Example");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        long start = System.currentTimeMillis();
        JavaRDD data = jsc.textFile(input);
        JavaRDD parsedData = data.map((Function)new Function<String, Vector>(){

            public Vector call(String s) {
                String[] sarray = s.split(" ");
                double[] values = new double[sarray.length];
                for (int i = 0; i < sarray.length; ++i) {
                    values[i] = Double.parseDouble(sarray[i]);
                }
                return Vectors.dense((double[])values);
            }
        }).cache();
        double loadTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        final KMeansModel clusters = KMeans.train((RDD)parsedData.rdd(), (int)K, (int)maxIterations, (int)runs, (String)KMeans.K_MEANS_PARALLEL(), (long)127L);
        double trainingTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        double WSSSE = clusters.computeCost(parsedData.rdd());
        double testTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        JavaRDD vectorIndex = parsedData.map((Function)new Function<Vector, String>(){

            public String call(Vector point) {
                int ind = clusters.predict(point);
                return point.toString() + " " + Integer.toString(ind);
            }
        });
        vectorIndex.saveAsTextFile(output);
        double saveTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.printf("loadTime:%.3f, trainingTime:%.3f, testTime:%.3f, saveTime:%.3f\n", loadTime, trainingTime, testTime, saveTime);
        System.out.println("Within Set Sum of Squared Errors = " + WSSSE);
        jsc.stop();
    }
}

