/*
 * Decompiled with CFR 0.152.
 */
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KmeansApp$ {
    public static final KmeansApp$ MODULE$;

    static {
        new KmeansApp$();
    }

    public void main(String[] args) {
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        if (args.length < 4) {
            Predef$.MODULE$.println((Object)"usage: <input> <output> <numClusters> <maxIterations> <runs> - optional");
            System.exit(0);
        }
        SparkConf conf = new SparkConf();
        conf.setAppName("Spark KMeans Example");
        SparkContext sc = new SparkContext(conf);
        String input = args[0];
        String output = args[1];
        int K = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        int maxIterations = new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt();
        int runs = this.calculateRuns(args);
        long start = System.currentTimeMillis();
        RDD data = sc.textFile(input, sc.textFile$default$2());
        RDD parsedData = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String s) {
                return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(s)).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            }
        }, ClassTag$.MODULE$.apply(Vector.class)).cache();
        double loadTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        KMeansModel clusters = KMeans$.MODULE$.train(parsedData, K, maxIterations, runs, KMeans$.MODULE$.K_MEANS_PARALLEL(), 127L);
        double trainingTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"cluster centers: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])clusters.clusterCenters()).mkString(",")).toString());
        start = System.currentTimeMillis();
        RDD vectorsAndClusterIdx = parsedData.map((Function1)new Serializable(clusters){
            public static final long serialVersionUID = 0L;
            private final KMeansModel clusters$1;

            public final Tuple2<String, Object> apply(Vector point) {
                int prediction = this.clusters$1.predict(point);
                return new Tuple2((Object)point.toString(), (Object)BoxesRunTime.boxToInteger((int)prediction));
            }
            {
                this.clusters$1 = clusters$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        vectorsAndClusterIdx.saveAsTextFile(output);
        double saveTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        double WSSSE = clusters.computeCost(parsedData);
        double testTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        Predef$.MODULE$.println((Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"loadTime"), (Object)BoxesRunTime.boxToDouble((double)loadTime)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"trainingTime"), (Object)BoxesRunTime.boxToDouble((double)trainingTime)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"testTime"), (Object)BoxesRunTime.boxToDouble((double)testTime)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"saveTime"), (Object)BoxesRunTime.boxToDouble((double)saveTime))})), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(double x) {
                return JsonDSL$.MODULE$.double2jvalue(x);
            }
        }))));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Within Set Sum of Squared Errors = ").append((Object)BoxesRunTime.boxToDouble((double)WSSSE)).toString());
        sc.stop();
    }

    public int calculateRuns(String[] args) {
        return args.length > 4 ? new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt() : 1;
    }

    private KmeansApp$() {
        MODULE$ = this;
    }
}

