/*
 * Decompiled with CFR 0.152.
 */
package DecisionTree.src.main.java;

import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import scala.Tuple2;

public class DecisionTreeApp {
    public static void main(String[] args) {
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        if (args.length < 3) {
            System.out.println("usage: <input> <output> <numClass> <impurity> <maxDepth> <maxBins> <mode:regression/Classification>");
            System.exit(0);
        }
        String input = args[0];
        String output = args[1];
        Integer numClasses = Integer.parseInt(args[2]);
        String impurity = args[3];
        Integer maxDepth = Integer.parseInt(args[4]);
        Integer maxBins = Integer.parseInt(args[5]);
        String mode = args[6];
        HashMap categoricalFeaturesInfo = new HashMap();
        SparkConf conf = new SparkConf().setAppName("DecisionTree classification Example");
        JavaSparkContext sc = new JavaSparkContext(conf);
        long start = System.currentTimeMillis();
        JavaRDD tmpdata = sc.textFile(input);
        JavaRDD data = tmpdata.map((Function)new Function<String, LabeledPoint>(){

            public LabeledPoint call(String line) {
                return LabeledPoint.parse((String)line);
            }
        });
        double loadTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        DecisionTreeModel tmpmodel = mode.equals("Classification") ? DecisionTree.trainClassifier((JavaRDD)data, (int)numClasses, categoricalFeaturesInfo, (String)impurity, (int)maxDepth, (int)maxBins) : DecisionTree.trainRegressor((JavaRDD)data, categoricalFeaturesInfo, (String)impurity, (int)maxDepth, (int)maxBins);
        double trainingTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        start = System.currentTimeMillis();
        final DecisionTreeModel model = tmpmodel;
        JavaPairRDD predictionAndLabel = data.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> call(LabeledPoint p) {
                return new Tuple2((Object)model.predict(p.features()), (Object)p.label());
            }
        });
        Double trainErr = 1.0 * (double)predictionAndLabel.filter((Function)new Function<Tuple2<Double, Double>, Boolean>(){

            public Boolean call(Tuple2<Double, Double> pl) {
                return !((Double)pl._1()).equals(pl._2());
            }
        }).count() / (double)data.count();
        double testTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.printf("{\"loadTime\":%.3f,\"trainingTime\":%.3f,\"testTime\":%.3f}\n", loadTime, trainingTime, testTime);
        System.out.println("Training error: " + trainErr);
        System.out.println("Learned classification tree model:\n" + model);
        sc.stop();
    }
}

