/*
 * Decompiled with CFR 0.152.
 */
package PCA.src.main.scala;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.PCA;
import org.apache.spark.mllib.feature.PCAModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PCAApp$ {
    public static final PCAApp$ MODULE$;

    static {
        new PCAApp$();
    }

    public void main(String[] args) {
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"usage: <input> <dimensions>");
            System.exit(0);
        }
        SparkConf conf = new SparkConf();
        conf.setAppName("Spark PCA Example");
        SparkContext sc = new SparkContext(conf);
        String input = args[0];
        int dimensions = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        Predef$.MODULE$.println((Object)"START load");
        long start = System.currentTimeMillis();
        RDD data = MLUtils$.MODULE$.loadLabeledPoints(sc, input).cache();
        double loadTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        Predef$.MODULE$.println((Object)"START training");
        start = System.currentTimeMillis();
        PCAModel pca = new PCA(dimensions).fit(data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(LabeledPoint x$1) {
                return x$1.features();
            }
        }, ClassTag$.MODULE$.apply(Vector.class)));
        double trainingTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        Predef$.MODULE$.println((Object)"START test");
        start = System.currentTimeMillis();
        RDD training_pca = data.map((Function1)new Serializable(pca){
            public static final long serialVersionUID = 0L;
            private final PCAModel pca$1;

            public final LabeledPoint apply(LabeledPoint p) {
                Vector x$2 = this.pca$1.transform(p.features());
                double x$3 = p.copy$default$1();
                return p.copy(x$3, x$2);
            }
            {
                this.pca$1 = pca$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        long numData = training_pca.count();
        double testTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        Predef$.MODULE$.println((Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"loadTime"), (Object)BoxesRunTime.boxToDouble((double)loadTime)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"trainingTime"), (Object)BoxesRunTime.boxToDouble((double)trainingTime)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"testTime"), (Object)BoxesRunTime.boxToDouble((double)testTime))})), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(double x) {
                return JsonDSL$.MODULE$.double2jvalue(x);
            }
        }))));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Number of Data = ").append((Object)BoxesRunTime.boxToLong((long)numData)).toString());
        sc.stop();
    }

    private PCAApp$() {
        MODULE$ = this;
    }
}

