/*
 * Decompiled with CFR 0.152.
 */
package LinearRegression.src.main.java;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.LinearDataGenerator;
import org.apache.spark.rdd.RDD;

public class LinearRegressionDataGen {
    public static void main(String[] args) {
        Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        if (args.length < 5) {
            System.out.println("usage: <output> <nExamples> <nFeatures> <eps> <intercept> <numPar>");
            System.exit(0);
        }
        String output = args[0];
        int nExamples = Integer.parseInt(args[1]);
        int nFeatures = Integer.parseInt(args[2]);
        double eps = Double.parseDouble(args[3]);
        double intercepts = Double.parseDouble(args[4]);
        int numPar = args.length > 5 ? Integer.parseInt(args[5]) : (System.getProperty("spark.default.parallelism") != null ? Integer.parseInt(System.getProperty("spark.default.parallelism")) : 2);
        SparkConf conf = new SparkConf().setAppName("Liner Regression data generation");
        SparkContext sc = new SparkContext(conf);
        RDD data = LinearDataGenerator.generateLinearRDD((SparkContext)sc, (int)nExamples, (int)nFeatures, (double)eps, (int)numPar, (double)intercepts);
        JavaRDD tmpdata = data.toJavaRDD();
        JavaRDD parsedData = tmpdata.map((Function)new Function<LabeledPoint, String>(){

            public String call(LabeledPoint s) {
                return s.toString();
            }
        });
        parsedData.saveAsTextFile(output);
    }
}

