/*
 * Decompiled with CFR 0.152.
 */
package src.main.scala;

import org.apache.log4j.Level;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.util.GraphGenerators$;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class pageRankDataGenRun$
implements Logging {
    public static final pageRankDataGenRun$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new pageRankDataGenRun$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void main(String[] args) {
        org.apache.log4j.Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
        org.apache.log4j.Logger.getLogger((String)"org.eclipse.jetty.server").setLevel(Level.OFF);
        if (args.length < 5) {
            Predef$.MODULE$.println((Object)"usage: <input> <output>; datagen:  <numVertices> <numPartitions> <mu> <sigma> ; run: <maxIterations> <tolerance> <resetProb> ");
            System.exit(0);
        }
        SparkConf conf = new SparkConf();
        conf.setAppName("Spark PageRank Application");
        SparkContext sc = new SparkContext(conf);
        String input = args[0];
        String output = args[1];
        int numVertices = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        int numPar = new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt();
        double mu = new StringOps(Predef$.MODULE$.augmentString(args[4])).toDouble();
        double sigma = new StringOps(Predef$.MODULE$.augmentString(args[5])).toDouble();
        int numIter = new StringOps(Predef$.MODULE$.augmentString(args[6])).toInt();
        double tolerance = new StringOps(Predef$.MODULE$.augmentString(args[7])).toDouble();
        double resetProb = new StringOps(Predef$.MODULE$.augmentString(args[8])).toDouble();
        Graph graph = GraphGenerators$.MODULE$.logNormalGraph(sc, numVertices, numPar, mu, sigma, GraphGenerators$.MODULE$.logNormalGraph$default$6());
        VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices().cache();
        double err = 0.02;
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("The two different is %.2f\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)err)})));
        staticRanks.saveAsTextFile(output);
        sc.stop();
    }

    public double compareRanks(VertexRDD<Object> a, VertexRDD<Object> b) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(a.leftJoin(b, (Function3)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(long x0$1, double x1$1, Option<Object> x2$1) {
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)BoxesRunTime.boxToDouble((double)x1$1), x2$1);
                if (tuple3 != null) {
                    double a = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    Option bOpt = (Option)tuple3._3();
                    double d = (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    }))) * (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    })));
                    return d;
                }
                throw new MatchError((Object)tuple3);
            }
        }, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    double error;
                    double d = error = tuple2._2$mcD$sp();
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).sum();
    }

    private pageRankDataGenRun$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

