/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.HighwatermarkPersistenceTest$;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.SystemTime$;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.I0Itec.zkclient.ZkClient;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u000f\ta\u0002*[4io\u0006$XM]7be.\u0004VM]:jgR,gnY3UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0017)+f.\u001b;4'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001C\u0002\u0013\u0005\u0011$A\u0004d_:4\u0017nZ:\u0016\u0003i\u00012a\u0007\u0012%\u001b\u0005a\"BA\u000f\u001f\u0003%IW.\\;uC\ndWM\u0003\u0002 A\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u000f\u0003\t1K7\u000f\u001e\t\u0003-\u0015J!A\n\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0007Q\u0001\u0001\u000b\u0011\u0002\u000e\u0002\u0011\r|gNZ5hg\u0002BqA\u000b\u0001C\u0002\u0013\u00051&A\u0003u_BL7-F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aa\u0015;sS:<\u0007BB\u001b\u0001A\u0003%A&\u0001\u0004u_BL7\r\t\u0005\bo\u0001\u0011\r\u0011\"\u00019\u0003-awnZ'b]\u0006<WM]:\u0016\u0003e\u00022a\u0007\u0012;!\tYd(D\u0001=\u0015\tiD!A\u0002m_\u001eL!a\u0010\u001f\u0003\u00151{w-T1oC\u001e,'\u000f\u0003\u0004B\u0001\u0001\u0006I!O\u0001\rY><W*\u00198bO\u0016\u00148\u000f\t\u0005\u0006\u0007\u0002!\t\u0001R\u0001\ti\u0016\f'\u000fZ8x]R\tQ\t\u0005\u0002G\u000f6\t\u0001%\u0003\u0002IA\t!QK\\5uQ\t\u0011%\n\u0005\u0002L\u001b6\tAJ\u0003\u0002\f\u001d%\u0011a\n\u0014\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006!\u0002!\t\u0001R\u0001,i\u0016\u001cH\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007+\u001a:tSN$XM\\2f'&tw\r\\3QCJ$\u0018\u000e^5p]\")!\u000b\u0001C\u0001\t\u0006qC/Z:u\u0011&<\u0007nV1uKJl\u0017M]6QKJ\u001c\u0018n\u001d;f]\u000e,W*\u001e7uSBdW\rU1si&$\u0018n\u001c8t\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0019Aw/\u001c$peR!a+\u00170f!\t1u+\u0003\u0002YA\t!Aj\u001c8h\u0011\u0015Q6\u000b1\u0001\\\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"A\u0006/\n\u0005u\u0013!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0006UM\u0003\ra\u0018\t\u0003A\u000et!AR1\n\u0005\t\u0004\u0013A\u0002)sK\u0012,g-\u0003\u00024I*\u0011!\r\t\u0005\u0006MN\u0003\raZ\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"A\u00125\n\u0005%\u0004#aA%oi\u0002")
public class HighwatermarkPersistenceTest
extends JUnit3Suite {
    private final List<KafkaConfig> configs = (List)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.createBrokerConfigs$default$2()).map((Function1)new $anonfun$1(this), List$.MODULE$.canBuildFrom());
    private final String topic;
    private final List<LogManager> logManagers = (List)this.configs().map((Function1)new $anonfun$2(this), List$.MODULE$.canBuildFrom());

    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public List<LogManager> logManagers() {
        return this.logManagers;
    }

    @After
    public void teardown() {
        this.logManagers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogManager manager) {
                Predef$.MODULE$.refArrayOps((Object[])manager.logDirs()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(File dir) {
                        Utils$.MODULE$.rm(dir);
                    }
                });
            }
        });
    }

    public void testHighWatermarkPersistenceSinglePartition() {
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        EasyMock.replay((Object[])new Object[]{zkClient});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), (Time)new MockTime(), zkClient, (Scheduler)scheduler, (LogManager)this.logManagers().apply(0), new AtomicBoolean(false));
        replicaManager.startup();
        replicaManager.checkpointHighWatermarks();
        long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)fooPartition0Hw));
        Partition partition0 = replicaManager.getOrCreatePartition(this.topic(), 0);
        Log log0 = ((LogManager)this.logManagers().apply(0)).createLog(new TopicAndPartition(this.topic(), 0), new LogConfig(LogConfig$.MODULE$.apply$default$1(), LogConfig$.MODULE$.apply$default$2(), LogConfig$.MODULE$.apply$default$3(), LogConfig$.MODULE$.apply$default$4(), LogConfig$.MODULE$.apply$default$5(), LogConfig$.MODULE$.apply$default$6(), LogConfig$.MODULE$.apply$default$7(), LogConfig$.MODULE$.apply$default$8(), LogConfig$.MODULE$.apply$default$9(), LogConfig$.MODULE$.apply$default$10(), LogConfig$.MODULE$.apply$default$11(), LogConfig$.MODULE$.apply$default$12(), LogConfig$.MODULE$.apply$default$13(), LogConfig$.MODULE$.apply$default$14(), LogConfig$.MODULE$.apply$default$15(), LogConfig$.MODULE$.apply$default$16()));
        Replica leaderReplicaPartition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), partition0, (Time)SystemTime$.MODULE$, 0L, (Option)new Some((Object)log0));
        partition0.addReplicaIfNotExists(leaderReplicaPartition0);
        Replica followerReplicaPartition0 = new Replica(((KafkaConfig)this.configs().last()).brokerId(), partition0, (Time)SystemTime$.MODULE$, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
        partition0.addReplicaIfNotExists(followerReplicaPartition0);
        replicaManager.checkpointHighWatermarks();
        fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)leaderReplicaPartition0.highWatermark().messageOffset()), (Object)BoxesRunTime.boxToLong((long)fooPartition0Hw));
        ((Replica)partition0.getReplica(partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replicaManager.checkpointHighWatermarks();
        fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)leaderReplicaPartition0.highWatermark().messageOffset()), (Object)BoxesRunTime.boxToLong((long)fooPartition0Hw));
        EasyMock.verify((Object[])new Object[]{zkClient});
    }

    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        EasyMock.replay((Object[])new Object[]{zkClient});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), (Time)new MockTime(), zkClient, (Scheduler)scheduler, (LogManager)this.logManagers().apply(0), new AtomicBoolean(false));
        replicaManager.startup();
        replicaManager.checkpointHighWatermarks();
        long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)topic1Partition0Hw));
        Partition topic1Partition0 = replicaManager.getOrCreatePartition(topic1, 0);
        Log topic1Log0 = ((LogManager)this.logManagers().apply(0)).createLog(new TopicAndPartition(topic1, 0), new LogConfig(LogConfig$.MODULE$.apply$default$1(), LogConfig$.MODULE$.apply$default$2(), LogConfig$.MODULE$.apply$default$3(), LogConfig$.MODULE$.apply$default$4(), LogConfig$.MODULE$.apply$default$5(), LogConfig$.MODULE$.apply$default$6(), LogConfig$.MODULE$.apply$default$7(), LogConfig$.MODULE$.apply$default$8(), LogConfig$.MODULE$.apply$default$9(), LogConfig$.MODULE$.apply$default$10(), LogConfig$.MODULE$.apply$default$11(), LogConfig$.MODULE$.apply$default$12(), LogConfig$.MODULE$.apply$default$13(), LogConfig$.MODULE$.apply$default$14(), LogConfig$.MODULE$.apply$default$15(), LogConfig$.MODULE$.apply$default$16()));
        Replica leaderReplicaTopic1Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), topic1Partition0, (Time)SystemTime$.MODULE$, 0L, (Option)new Some((Object)topic1Log0));
        topic1Partition0.addReplicaIfNotExists(leaderReplicaTopic1Partition0);
        replicaManager.checkpointHighWatermarks();
        topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)leaderReplicaTopic1Partition0.highWatermark().messageOffset()), (Object)BoxesRunTime.boxToLong((long)topic1Partition0Hw));
        ((Replica)topic1Partition0.getReplica(topic1Partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replicaManager.checkpointHighWatermarks();
        topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToLong((long)leaderReplicaTopic1Partition0.highWatermark().messageOffset()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToLong((long)topic1Partition0Hw));
        Partition topic2Partition0 = replicaManager.getOrCreatePartition(topic2, 0);
        Log topic2Log0 = ((LogManager)this.logManagers().apply(0)).createLog(new TopicAndPartition(topic2, 0), new LogConfig(LogConfig$.MODULE$.apply$default$1(), LogConfig$.MODULE$.apply$default$2(), LogConfig$.MODULE$.apply$default$3(), LogConfig$.MODULE$.apply$default$4(), LogConfig$.MODULE$.apply$default$5(), LogConfig$.MODULE$.apply$default$6(), LogConfig$.MODULE$.apply$default$7(), LogConfig$.MODULE$.apply$default$8(), LogConfig$.MODULE$.apply$default$9(), LogConfig$.MODULE$.apply$default$10(), LogConfig$.MODULE$.apply$default$11(), LogConfig$.MODULE$.apply$default$12(), LogConfig$.MODULE$.apply$default$13(), LogConfig$.MODULE$.apply$default$14(), LogConfig$.MODULE$.apply$default$15(), LogConfig$.MODULE$.apply$default$16()));
        Replica leaderReplicaTopic2Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), topic2Partition0, (Time)SystemTime$.MODULE$, 0L, (Option)new Some((Object)topic2Log0));
        topic2Partition0.addReplicaIfNotExists(leaderReplicaTopic2Partition0);
        replicaManager.checkpointHighWatermarks();
        long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)leaderReplicaTopic2Partition0.highWatermark().messageOffset()), (Object)BoxesRunTime.boxToLong((long)topic2Partition0Hw));
        ((Replica)topic2Partition0.getReplica(topic2Partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)15L), (Object)BoxesRunTime.boxToLong((long)leaderReplicaTopic2Partition0.highWatermark().messageOffset()));
        ((Replica)topic1Partition0.getReplica(topic1Partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToLong((long)leaderReplicaTopic1Partition0.highWatermark().messageOffset()));
        replicaManager.checkpointHighWatermarks();
        topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)15L), (Object)BoxesRunTime.boxToLong((long)topic2Partition0Hw));
        topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToLong((long)topic1Partition0Hw));
        EasyMock.verify((Object[])new Object[]{zkClient});
    }

    public long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpoint)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().apply(0)).getAbsolutePath())).read().getOrElse((Object)new TopicAndPartition(topic, partition), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

