/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import junit.framework.Assert;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.SnappyCompressionCodec$;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyOutputStream;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001\u000f\t1R*Z:tC\u001e,7i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\t\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\r\u000e\u0003IQ!a\u0005\u000b\u0002\u000b),h.\u001b;\u000b\u0005U1\u0012!C:dC2\fG/Z:u\u0015\u00059\u0012aA8sO&\u0011\u0011D\u0005\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003q!Xm\u001d;TS6\u0004H.Z\"p[B\u0014Xm]:EK\u000e|W\u000e\u001d:fgN$\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000f\u000b\u0002 SA\u0011!\u0006L\u0007\u0002W)\u00111CF\u0005\u0003[-\u0012A\u0001V3ti\")\u0001\u0005\u0001C\u0001_Q\u0011!\u0005\r\u0005\u0006c9\u0002\rAM\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\"AH\u001a\n\u0005Q\u0012!\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0011\u00151\u0004\u0001\"\u0001\"\u0003u!Xm\u001d;D_6\u0004H.\u001a=D_6\u0004(/Z:t\t\u0016\u001cw.\u001c9sKN\u001c\bFA\u001b*\u0011\u0015I\u0004\u0001\"\u0001;\u0003EI7o\u00158baBL\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0002wA\u00111\u0005P\u0005\u0003{\u0011\u0012qAQ8pY\u0016\fg\u000eC\u0003@\u0001\u0011\u0005!(\u0001\bjg2SF'\u0011<bS2\f'\r\\3")
public class MessageCompressionTest
implements JUnitSuite {
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    @Test
    public void testSimpleCompressDecompress() {
        ArrayBuffer codecs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompressionCodec[]{GZIPCompressionCodec$.MODULE$}));
        Object object = this.isSnappyAvailable() ? codecs.$plus$eq((Object)SnappyCompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        Object object2 = this.isLZ4Available() ? codecs.$plus$eq((Object)LZ4CompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        codecs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageCompressionTest $outer;

            public final void apply(CompressionCodec codec) {
                this.$outer.testSimpleCompressDecompress(codec);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void testSimpleCompressDecompress(CompressionCodec compressionCodec) {
        List messages2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hi there".getBytes()), new Message("I am fine".getBytes()), new Message("I am not so well today".getBytes())}));
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet(compressionCodec, (Seq)messages2);
        Assert.assertEquals((Object)compressionCodec, (Object)((MessageAndOffset)messageSet.shallowIterator().next()).message().compressionCodec());
        List decompressed = messageSet.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset x$1) {
                return x$1.message();
            }
        }).toList();
        Assert.assertEquals((Object)messages2, (Object)decompressed);
    }

    @Test
    public void testComplexCompressDecompress() {
        List messages2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hi there".getBytes()), new Message("I am fine".getBytes()), new Message("I am not so well today".getBytes())}));
        ByteBufferMessageSet message = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)messages2.slice(0, 2));
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{((MessageAndOffset)message.shallowIterator().next()).message()}));
        List complexMessages = messages2.slice(2, 3).$colon$colon$colon(list);
        ByteBufferMessageSet complexMessage = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)complexMessages);
        List decompressedMessages = complexMessage.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset x$3) {
                return x$3.message();
            }
        }).toList();
        Assert.assertEquals((Object)messages2, (Object)decompressedMessages);
    }

    public boolean isSnappyAvailable() {
        boolean bl;
        try {
            SnappyOutputStream snappy = new SnappyOutputStream((OutputStream)new ByteArrayOutputStream());
            bl = true;
        }
        catch (SnappyError snappyError) {
            bl = false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        return bl;
    }

    public boolean isLZ4Available() {
        boolean bl;
        try {
            LZ4BlockOutputStream lz4 = new LZ4BlockOutputStream((OutputStream)new ByteArrayOutputStream());
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        return bl;
    }

    public MessageCompressionTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
    }
}

