/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminUtils$;
import kafka.admin.DeleteTopicTest$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentStatus;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.message.CompressionCodec;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.OffsetCheckpoint;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002R3mKR,Gk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0005\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tY!*\u00168jiN\u001aV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0002{W&\u0011q\u0003\u0006\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0003y\u0012a\t;fgR$U\r\\3uKR{\u0007/[2XSRD\u0017\t\u001c7BY&4XMU3qY&\u001c\u0017m\u001d\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t!QK\\5uQ\tir\u0005\u0005\u0002)U5\t\u0011F\u0003\u0002\f\u001d%\u00111&\u000b\u0002\u0005)\u0016\u001cH\u000fC\u0003.\u0001\u0011\u0005q$\u0001\u0016uKN$(+Z:v[\u0016$U\r\\3uKR{\u0007/[2XSRD'+Z2pm\u0016\u0014X\r\u001a$pY2|w/\u001a:)\u00051:\u0003\"\u0002\u0019\u0001\t\u0003y\u0012!\u000b;fgR\u0014Vm];nK\u0012+G.\u001a;f)>\u0004\u0018nY(o\u0007>tGO]8mY\u0016\u0014h)Y5m_Z,'\u000f\u000b\u00020O!)1\u0007\u0001C\u0001?\u0005QC/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u\tV\u0014\u0018N\\4EK2,G/\u001a+pa&\u001c\u0007F\u0001\u001a(\u0011\u00151\u0004\u0001\"\u0001 \u0003\u0005\"Xm\u001d;EK2,G/\u001a+pa&\u001cG)\u001e:j]\u001e\fE\r\u001a)beRLG/[8oQ\t)t\u0005C\u0003:\u0001\u0011\u0005q$A\u0011uKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\r\u000b\u00029O!)A\b\u0001C\u0001?\u0005qB/Z:u%\u0016\u001c'/Z1uKR{\u0007/[2BMR,'\u000fR3mKRLwN\u001c\u0015\u0003w\u001dBQa\u0010\u0001\u0005\u0002}\t!\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti&tw\rV8qS\u000eD#AP\u0014\t\u000b\t\u0003A\u0011A\u0010\u00025Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e<\u0016\u000e\u001e5DY\u0016\fg.\u001a:)\u0005\u0005;\u0003\"B#\u0001\t\u00131\u0015!G2sK\u0006$X\rV3tiR{\u0007/[2B]\u0012\u001cE.^:uKJ$\"aR-\u0011\u0007!\u00036K\u0004\u0002J\u001d:\u0011!*T\u0007\u0002\u0017*\u0011AJB\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!a\u0014\u0012\u0002\u000fA\f7m[1hK&\u0011\u0011K\u0015\u0002\u0004'\u0016\f(BA(#!\t!v+D\u0001V\u0015\t1F!\u0001\u0004tKJ4XM]\u0005\u00031V\u00131bS1gW\u0006\u001cVM\u001d<fe\")!\f\u0012a\u00017\u0006)Ao\u001c9jGB\u0011Al\u0018\b\u0003CuK!A\u0018\u0012\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0017M\u0001\u0004TiJLgn\u001a\u0006\u0003=\nBQ!\u0012\u0001\u0005\n\r$2a\u00123f\u0011\u0015Q&\r1\u0001\\\u0011\u00151'\r1\u0001h\u00035\u0011'o\\6fe\u000e{gNZ5hgB\u0019\u0001\n\u00155\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017\u0001B;uS2T\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pU\nQ\u0001K]8qKJ$\u0018.Z:\t\u000bE\u0004A\u0011\u0002:\u0002'Y,'/\u001b4z)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8\u0015\u0007\u0001\u001aH\u000fC\u0003[a\u0002\u00071\fC\u0003va\u0002\u0007q)A\u0004tKJ4XM]:\t\u000b]\u0004A\u0011\u0002=\u0002\u0013]\u0014\u0018\u000e^3EkB\u001cHcB=\u0002\u0002\u0005\u0015\u0011\u0011\u0002\t\u0004\u0011BS\b\u0003B\u0011|{vL!\u0001 \u0012\u0003\rQ+\b\u000f\\33!\t\tc0\u0003\u0002\u0000E\t\u0019\u0011J\u001c;\t\r\u0005\ra\u000f1\u0001~\u0003\u001dqW/\\&fsNDa!a\u0002w\u0001\u0004i\u0018a\u00028v[\u0012+\bo\u001d\u0005\b\u0003\u00171\b\u0019AA\u0007\u0003\rawn\u001a\t\u0005\u0003\u001f\t\u0019\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0002\u0003\n\t\u0005U\u0011\u0011\u0003\u0002\u0004\u0019><\u0007")
public class DeleteTopicTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        this.verifyTopicDeletion(topic, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        Option leaderIdOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$1.get());
            }
            {
                this.leaderIdOpt$1 = leaderIdOpt$1;
            }
        })).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers, follower){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$1;
            private final Seq servers$2;
            public final KafkaServer follower$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)this.servers$2.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() != this.$outer.follower$1.config().brokerId();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$1).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$1 = topicAndPartition$1;
                this.servers$2 = servers$2;
                this.follower$1 = follower$1;
            }
        }, "Replicas 0,1 have not deleted log.", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, "Admin path /admin/delete_topic/test path deleted even when a follower replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3());
        follower.startup();
        this.verifyTopicDeletion(topic, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$2) {
                x$2.shutdown();
            }
        });
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        int controllerId = ZkUtils$.MODULE$.getController(this.zkClient());
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head();
        Option leaderIdOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, controllerId, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;
            private final Option leaderIdOpt$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$2.get()) && s.config().brokerId() != this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
                this.leaderIdOpt$2 = leaderIdOpt$2;
            }
        })).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        controller.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        }, "Admin path /admin/delete_topic/test path deleted even when a replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3());
        controller.startup();
        follower.startup();
        this.verifyTopicDeletion(topic, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$3) {
                x$3.shutdown();
            }
        });
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        List<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, false);
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        List allServers = (List)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        List servers = (List)allServers.filter((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$1;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
            }
        });
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$2;
            private final List servers$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$3.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPartitionReassignmentDuringDeleteTopic$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$2).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$2 = topicAndPartition$2;
                this.servers$3 = servers$3;
            }
        }, "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Option leaderIdOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((LinearSeqOptimized)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$3.get());
            }
            {
                this.leaderIdOpt$3 = leaderIdOpt$3;
            }
        })).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        Seq oldAssignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.zkClient(), topic, 0);
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final TopicAndPartition topicAndPartition$2;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = ZkUtils$.MODULE$.getPartitionsBeingReassigned(this.$outer.zkClient()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$4) {
                        return x$4.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkClient(), this.topicAndPartition$2, this.newReplicas$1, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topicAndPartition$2), (Object)this.newReplicas$1)})), partitionsBeingReassigned);
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentFailed$) : reassignmentFailed$ != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$2 = topicAndPartition$2;
                this.newReplicas$1 = newReplicas$1;
            }
        }, "Partition reassignment shouldn't complete.", TestUtils$.MODULE$.waitUntilTrue$default$3());
        int controllerId = ZkUtils$.MODULE$.getController(this.zkClient());
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head();
        Assert.assertFalse((String)"Partition reassignment should fail", (boolean)controller.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)topicAndPartition));
        Seq assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.zkClient(), topic, 0);
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower.startup();
        this.verifyTopicDeletion(topic, (Seq<KafkaServer>)servers);
        allServers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$5) {
                x$5.shutdown();
            }
        });
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        Option leaderIdOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$4;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$4.get());
            }
            {
                this.leaderIdOpt$4 = leaderIdOpt$4;
            }
        })).last();
        TopicAndPartition newPartition = new TopicAndPartition(topic, 1);
        follower.shutdown();
        AdminUtils$.MODULE$.addPartitions(this.zkClient(), topic, 2, "0:1:2,0:1:2", false, AdminUtils$.MODULE$.addPartitions$default$6());
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        follower.startup();
        this.verifyTopicDeletion(topic, servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, servers, newPartition){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final TopicAndPartition newPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$4.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteTopicDuringAddPartition$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.newPartition$1).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.servers$4 = servers$4;
                this.newPartition$1 = newPartition$1;
            }
        }, "Replica logs not for new partition [test,1] not deleted after delete topic is complete.", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$6) {
                x$6.shutdown();
            }
        });
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        String topic = "test";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        TopicAndPartition newPartition = new TopicAndPartition(topic, 1);
        AdminUtils$.MODULE$.addPartitions(this.zkClient(), topic, 2, "0:1:2,0:1:2", AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        this.verifyTopicDeletion(topic, servers);
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)BoxesRunTime.unboxToBoolean((Object)servers.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition newPartition$2;

            public final boolean apply(boolean res, KafkaServer server) {
                return res && server.getLogManager().getLog(this.newPartition$2).isEmpty();
            }
            {
                this.newPartition$2 = newPartition$2;
            }
        })));
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$7) {
                x$7.shutdown();
            }
        });
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        this.verifyTopicDeletion(topic, servers);
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"New leader should be elected after re-creating topic test", (boolean)leaderIdOpt.isDefined());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$3;
            private final Seq servers$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$5.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecreateTopicAfterDeletion$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$3).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$3 = topicAndPartition$3;
                this.servers$5 = servers$5;
            }
        }, "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$8) {
                x$8.shutdown();
            }
        });
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), "test2");
        this.verifyTopicDeletion("test2", servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$4;
            private final Seq servers$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$6.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteNonExistingTopic$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$4).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$4 = topicAndPartition$4;
                this.servers$6 = servers$6;
            }
        }, "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)ZkUtils$.MODULE$.pathExists(this.zkClient(), ZkUtils$.MODULE$.getTopicPath(topic)));
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$9) {
                x$9.shutdown();
            }
        });
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topicName, 0);
        String topic = topicAndPartition.topic();
        List<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, false);
        ((Properties)brokerConfigs.apply(0)).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.apply(0)).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.apply(0)).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.apply(0)).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.apply(0)).setProperty("log.segment.delete.delay.ms", "1000");
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, (Seq<Properties>)brokerConfigs);
        KafkaServer server = (KafkaServer)servers.apply(0);
        Log log = (Log)server.logManager().getLog(topicAndPartition).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$1 = server.logManager().cleaner();
        String x$11 = topicName;
        int x$12 = 0;
        long x$13 = 0L;
        long x$14 = qual$1.awaitCleaned$default$4();
        qual$1.awaitCleaned(x$11, x$12, x$13, x$14);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), "test");
        this.verifyTopicDeletion("test", servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$10) {
                x$10.shutdown();
            }
        });
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic) {
        List<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, false);
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        return this.createTestTopicAndCluster(topic, (Seq<Properties>)brokerConfigs);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs) {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$5;
            private final Seq servers$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$7.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createTestTopicAndCluster$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$5).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$5 = topicAndPartition$5;
                this.servers$7 = servers$7;
            }
        }, "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3());
        return servers;
    }

    private void verifyTopicDeletion(String topic, Seq<KafkaServer> servers) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, "Admin path /admin/delete_topic/test path not deleted even after a replica is restarted", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getTopicPath(this.topic$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, "Topic path /brokers/topics/test not deleted after /admin/delete_topic/test path is deleted", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers){
            public static final long serialVersionUID = 0L;
            public final String topic$1;
            private final Seq servers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$1.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$verifyTopicDeletion$3 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(boolean res, KafkaServer server) {
                        if (!res) return false;
                        Option option = server.replicaManager().getPartition(this.$outer.topic$1, 0);
                        None$ none$ = None$.MODULE$;
                        if (option != null) {
                            if (!option.equals(none$)) return false;
                            return true;
                        }
                        if (none$ == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topic$1 = topic$1;
                this.servers$1 = servers$1;
            }
        }, "Replica manager's should have deleted all of this topic's partitions", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)BoxesRunTime.unboxToBoolean((Object)servers.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$6;

            public final boolean apply(boolean res, KafkaServer server) {
                return res && server.getLogManager().getLog(this.topicAndPartition$6).isEmpty();
            }
            {
                this.topicAndPartition$6 = topicAndPartition$6;
            }
        })));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers){
            public static final long serialVersionUID = 0L;
            public final String topic$1;
            private final Seq servers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$1.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$verifyTopicDeletion$4 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(boolean res, KafkaServer server) {
                        if (!res) return false;
                        TopicAndPartition topicAndPartition = new TopicAndPartition(this.$outer.topic$1, 0);
                        File logdir = server.getLogManager().logDirs()[0];
                        Map checkpoints = new OffsetCheckpoint(new File(logdir, "cleaner-offset-checkpoint")).read();
                        if (!checkpoints.contains((Object)topicAndPartition)) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topic$1 = topic$1;
                this.servers$1 = servers$1;
            }
        }, "Cleaner offset for deleted partition should have been removed", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        IntRef counter = new IntRef(0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log, counter){
            public static final long serialVersionUID = 0L;
            private final int numKeys$1;
            public final Log log$1;
            public final IntRef counter$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int dup) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.counter$1.elem;
                        byte[] x$15 = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.counter$1.elem)).toString().getBytes();
                        byte[] x$16 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        CompressionCodec x$17 = TestUtils$.MODULE$.singleMessageSet$default$2();
                        this.$outer.log$1.append(TestUtils$.MODULE$.singleMessageSet(x$15, x$17, x$16), true);
                        ++this.$outer.counter$1.elem;
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.counter$1 = counter$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public DeleteTopicTest() {
        ZooKeeperTestHarness$class.$init$(this);
    }
}

