﻿Imports System.Data
Imports System.Configuration
Imports System.Collections
Imports System.Web
Imports System.Web.Security
Partial Class Reports
    Inherits System.Web.UI.Page
    Private _dataSet As New AppXmlDataSet()
    Protected Sub Page_Init(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Init
        LoadReportParameters(Request.QueryString("Report"))
    End Sub
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        If Not IsPostBack Then
            CurReportName = Request.QueryString("Report").Trim()
            ' ViewState("CurrentReportName") = CurReportName
            InitalReportCategory(CurReportName)
            ShowReportFormatOptions(CurReportName)
            ShowReportInstances(CurReportName)
        End If
    End Sub
    Private Sub LoadReportParameters(ByVal reportName As String)
        Dim dt = _dataSet.GetReportParameters(reportName)
        For Each dr As dsReport.ReportParametersRow In dt.Rows
            Dim control As Control = Nothing
            Dim parameterControl As IParm = Nothing
            If dr.ParmType.ToUpper().StartsWith("DATERANGE") Then
                If dr.ParmDisplay Then
                    control = LoadControl("./modules/ReportParamDateRange.ascx")
                Else
                    control = LoadControl("./modules/ReportParamDateRangeHidden.ascx")
                End If
            ElseIf dr.ParmType.ToUpper().StartsWith("DATE") Then

                If dr.ParmDisplay Then
                    control = LoadControl("./modules/ReportParamDate.ascx")
                Else
                    control = LoadControl("./modules/ReportParamDateHidden.ascx")
                End If
            Else
                If dr.ParmDisplay Then
                    If dr.ParmMultiValue Then
                        If dr.ParmPickList.StartsWith("Cascading") = True Then
                            control = LoadControl("./modules/ReportParamStringCascadingMultiValue.ascx")
                        Else
                            control = LoadControl("./modules/ReportParamStringMultiValue.ascx")
                        End If
                    ElseIf dr.ParmPickList.StartsWith("Cascading") = True Then
                        control = LoadControl("./modules/ReportParamStringCascading.ascx")
                    Else
                        Dim dit As Date = New Date()

                        '9/16/2018
                        '2018.5k
                        'Bug Fix: Remove check for dash in parm description; this messes up string ranges if administrator changed description; Ticket #CEQ-368-49555
                        'If dr.ParmDefaultValue.Contains(",") And dr.ParmDescription.Contains("-") Then
                        If dr.ParmDefaultValue.Contains(",") Then
                            Dim kv = dr.ParmDefaultValue.Split(","c)
                            If (kv.Length > 1) Then
                                Dim checkformatTODATE = kv(0)
                                Dim checkformatDATE = kv(1)
                                If Externsions.TryConvertToDataTime(checkformatTODATE, dit) Then
                                    If (checkformatTODATE.Length <= 10) Then
                                        control = LoadControl("./modules/ReportParamDateRange.ascx")
                                    Else
                                        control = LoadControl("./modules/ReportParamDateTimeRange.ascx")
                                    End If
                                Else
                                    control = LoadControl("./modules/ReportParamStringRange.ascx")
                                End If
                            End If
                        Else
                            ' If (dr.ParmDescription.Contains("-")) Then
                            If Externsions.TryConvertToDataTime(dr.ParmDefaultValue, dit) Then
                                If (dr.ParmDefaultValue.Length <= 10) Then
                                    control = LoadControl("./modules/ReportParamDate.ascx")
                                Else
                                    control = LoadControl("./modules/ReportParamDateTime.ascx")
                                End If
                            Else
                                control = LoadControl("./modules/ReportParamString.ascx")
                            End If
                            'Else
                            'control = LoadControl("./modules/ReportParamString.ascx")
                            ' End If
                        End If
                    End If
                Else
                    control = LoadControl("./modules/ReportParamStringHidden.ascx")
                End If
            End If
            control.EnableViewState = True
            parameterControl = DirectCast(control, IParm)
            parameterControl.ParmName = dr.ParmName
            parameterControl.ParmDescription = dr.ParmDescription
            parameterControl.ParmPickList = dr.ParmPickList
            parameterControl.ParmDisplay = dr.ParmDisplay
            parameterControl.ParmDefaultValue = dr.ParmDefaultValue
            parameterControl.ParmApplyUserValue = dr.ParmApplyUserValue
            parameterControl.ParmType = dr.ParmType
            parameterControl.ParmMultiValue = dr.ParmMultiValue
            parameterControl.ParmManualEntry = dr.ParmManualEntry
            parameterControl.ParmUserValueField = dr.ParmUserValueField
            Dim paramValue As String = ""
            If parameterControl.ParmApplyUserValue AndAlso Not String.IsNullOrEmpty(paramValue) Then
                parameterControl.ParmDefaultValue = paramValue
            End If
            control.Visible = True   'parameterControl.ParmDisplay
            PH_ReportParameters.Controls.Add(control)
        Next
    End Sub
    Private Sub InitalReportCategory(ByVal reportName As String)
        Dim curCategory = GetCategory(reportName)
        If curCategory IsNot Nothing AndAlso curCategory.Rows.Count > 0 Then
            Img_Category.ImageUrl = TryCast(curCategory.Rows(0)("CategoryImage"), String)
            Lit_CategoryName.Text = TryCast(curCategory.Rows(0)("CategoryName"), String)
        End If
        Lit_ReportName.Text = CurReportName
        If Lit_CategoryName.Text.Trim() = "" Then
            Img_Category.Visible = False
            btn_Submit.Visible = False
        End If
    End Sub
    Private Function GetCategory(ByVal curReportName As String) As dsReport.CategoriesDataTable
        Dim report = _dataSet.GetReport(curReportName)
        If report IsNot Nothing AndAlso report.Rows.Count > 0 Then
            Dim curCats = _dataSet.GetReportCategory(TryCast(report.Rows(0)("CategoryName"), String))
            Return curCats
        Else
            Return Nothing
        End If
    End Function
    Public Property CurReportName() As String
        Get
            Return TryCast(ViewState("CurrentReportName"), String)
        End Get
        Set(ByVal value As String)
            ViewState("CurrentReportName") = value
        End Set
    End Property
    Protected Sub RBL_RptRunnerType_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles RBL_RptRunnerType.SelectedIndexChanged
        lblEmail.Visible = False
        txtEmailAddresses.Visible = False
        lblPrinters.Visible = False
        lstPrinters.Visible = False
        lblEmailValidate.Visible = False
        Dim choice As Integer = RBL_RptRunnerType.SelectedIndex
        Select Case choice
            'Case 0
            '    'Printers
            '    lblPrinters.Visible = True
            '    lstPrinters.Visible = True
            '    Exit Select
            'Case 1
            Case 1
                'Email
                lblEmail.Visible = False

                txtEmailAddresses.Visible = True
                'txtEmailAddresses.Text = CurrentUserEmail
                Exit Select
        End Select
    End Sub
    Protected Sub btn_Submit_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btn_Submit.Click
        ' condition for to check empty default value from cascading picklists
        If txtEmailAddresses.Visible AndAlso txtEmailAddresses.Text.Trim() Is "" Then
            'lblEmailValidate.Visible = True
            ScriptManager.RegisterStartupScript(Me, Me.GetType(), "DatavalidationMsg", "emailvalidation()", True)
            Exit Sub
        Else
            lblEmailValidate.Visible = False
        End If
        Dim CheckSelectedValue As Boolean = False
        Dim CheckDateStringRange As Boolean = False
        Dim count As Integer = 0
        For Each c As Control In PH_ReportParameters.Controls
            Dim parameterCheckControl As IParm = DirectCast(c, IParm)
            If parameterCheckControl.ParmMultiValue AndAlso parameterCheckControl.ParmDefaultValue = "" Then
                CheckSelectedValue = True
                ' Exit Sub
            End If
            If count = 0 Then
                If parameterCheckControl.ParmType = "DateRange" Then
                    If parameterCheckControl.ParmDefaultValue = "" Or parameterCheckControl.ParmDefaultValue = "," Then
                        CheckDateStringRange = True
                    ElseIf parameterCheckControl.ParmDefaultValue.Contains(",") Then
                        CheckDateStringRange = False
                    End If
                End If
            ElseIf count = 2 Then
                If parameterCheckControl.ParmDescription.ToLower().Contains("fis") Then
                    If parameterCheckControl.ParmDefaultValue = "" Or parameterCheckControl.ParmDefaultValue = "," Then
                        If CheckDateStringRange = True Then
                            CheckDateStringRange = True
                        End If
                    Else
                        CheckDateStringRange = False
                    End If
                End If
            End If
            count = count + 1
        Next
        If CheckSelectedValue Then
            ScriptManager.RegisterStartupScript(Me, Me.GetType(), "DatavalidationMsg", "datavalidation()", True)
            Exit Sub
        End If
        If CheckDateStringRange Then
            ScriptManager.RegisterStartupScript(Me, Me.GetType(), "DaterangevalidationMsg", "daterangevalidation()", True)
            Exit Sub
        End If
        Dim dt As dsReport.ReportsDataTable = _dataSet.GetReport(CurReportName)
        Dim dr As dsReport.ReportsRow = dt(0)
        Dim objReport As New Report()
        objReport.IdentifyString = Guid.NewGuid().ToString().Replace("-", "")
        objReport.TemplateFileName = dr.TemplateFileName
        objReport.ReportName = CurReportName
        Dim refo = DirectCast(reportExportFormatOptions, modules_ReportExportFormatOptions)
        Try
            If (dr.OutputFormat = "0") Then
                objReport.FormatType = "PDF"
                objReport.FileExtension = "PDF"
            ElseIf (dr.OutputFormat = "1") Then
                objReport.FormatType = refo.SelectedReportType
                objReport.FileExtension = refo.SelectedFileExtension
            Else
                objReport.FormatType = dr.OutputFormat
                objReport.FileExtension = dr.OutputFormat
            End If
        Catch
            objReport.FormatType = "PDF"
            objReport.FileExtension = "PDF"
        End Try
        'Try
        '    If (dr.OutputFormat = 0) Then
        '        objReport.FormatType = "PDF"
        '        objReport.FileExtension = "PDF"
        '    Else
        '        objReport.FormatType = refo.SelectedReportType
        '        objReport.FileExtension = refo.SelectedFileExtension
        '    End If
        'Catch
        '    objReport.FormatType = "PDF"
        '    objReport.FileExtension = "PDF"
        'End Try
        Dim choice As Integer = RBL_RptRunnerType.SelectedIndex
        Select Case choice
            Case 1
                'Email
                objReport.DestinationFileName = txtEmailAddresses.Text
                objReport.DestinationType = "Mail"
                Exit Select
            Case Else
                Dim outputFolder = objReport.ReportDirectory & "\" & objReport.IdentifyString
                System.IO.Directory.CreateDirectory(outputFolder)
                objReport.DestinationFileName = outputFolder & "\" & objReport.ReportName.Replace(" ", "") & "." & objReport.FileExtension
                objReport.DestinationType = "FILE"
                Exit Select
        End Select
        Dim template As IBatchTemplate
        Try
            If Report.XmlFormatType.ToUpper() = "LEGACY" Then
                template = New LegacyBatchTemplate(objReport.TemplateDirectory + objReport.TemplateFileName)
            Else
                template = New BatchTemplate(objReport.TemplateDirectory + objReport.TemplateFileName)
            End If
        Catch ex As Exception
            Dim js = "window.alert('" + WebPortalResourceSet.GetResourceValue("WebPortalCommonResource", "BatchTemplateErrorTip", "can not find the Batch Template or Batch Template File is illegal format") + " ');"
            ScriptManager.RegisterStartupScript(Me, Me.GetType(), "errormsgtip", js, True)
            Return
        End Try
        template.DestinationName = objReport.DestinationFileName
        template.DestinationType = objReport.DestinationType
        template.FormatType = objReport.FormatType
        'template.WebPortalUserName = CurrentUser
        template.CancelExport = False
        If dr.AllowInstances Then
            Dim refIns = DirectCast(reportInstances, modules_ReportInstances)
            objReport.InstanceDirectory = Server.MapPath(refIns.getInstancesDir())
            objReport.InstanceNamingFormat = dr.NamingFormat
            objReport.InstanceOutput = "true"
            objReport.InstanceRetainingCount = dr.InstancesNum
        Else
            objReport.InstanceDirectory = ""
            objReport.InstanceNamingFormat = ""
            objReport.InstanceOutput = "false"
            objReport.InstanceRetainingCount = ""
        End If
        template.InstanceNamingFormat = objReport.InstanceNamingFormat
        template.InstanceDirectory = objReport.InstanceDirectory
        template.InstanceOutput = objReport.InstanceOutput
        template.InstanceRetainingCount = objReport.InstanceRetainingCount
        Dim DoTheEncryption As String = ConfigurationManager.AppSettings("UseWPLoginForDatabaseLogin")
        If DoTheEncryption = "1" Then
            template.DBUser = EncryptIt(TryCast(Session("CurrentUser"), String))
            template.DBPassword = EncryptIt(TryCast(Session("CurrentPwd"), String))
        End If
        Dim parameterControl As IParm = Nothing
        For Each c As Control In PH_ReportParameters.Controls
            parameterControl = DirectCast(c, IParm)
            template.SetReportParams(parameterControl.ParmName, parameterControl.ParmDefaultValue)
        Next
        template.SaveAs(objReport.InputDirectory + objReport.IdentifyString + objReport.ReportName.Replace(" ", "") + ".xml")

        Session(objReport.IdentifyString) = objReport
        Response.Redirect("result.aspx?id=" & objReport.IdentifyString)
    End Sub
    Private Function EncryptIt(ByVal strLogin As String) As String

        strLogin = Trim(strLogin)
        Dim i As Integer = 0
        Dim strResult As String = ""
        Dim strChar As String = ""
        For i = Len(strLogin) To 1 Step -1
            strChar = "0000" & Trim(CStr(Asc(Mid(strLogin, i, 1))))
            strResult = strResult & Right(strChar, 5) & Left(CStr(Rnd() * 1000), 1)
        Next
        Return strResult
    End Function
    Private Sub ShowReportFormatOptions(ByVal reportName As String)
        Dim report = _dataSet.GetReport(reportName)
        If report IsNot Nothing And report.Rows.Count > 0 Then
            Try
                Dim format = report(0)("OutputFormat")
                If (format = 1) Then
                    reportExportFormatOptions.Visible = True
                Else
                    reportExportFormatOptions.Visible = False
                End If
            Catch ex As Exception
                reportExportFormatOptions.Visible = False
            End Try
        End If
    End Sub
    Private Sub ShowReportInstances(ByVal reportName As String)
        Dim report = _dataSet.GetReport(reportName)
        If report IsNot Nothing And report.Rows.Count > 0 Then
            Try
                Session("sesReportname") = reportName
                'Session("sesCurrentUser") = CurrentUser
                Session("sesIsStaticReport") = report(0)("IsStaticReport").ToString()
                Dim instance As Boolean = report(0)("AllowInstances")
                If instance Then
                    reportInstances.Visible = True
                Else
                    reportInstances.Visible = False
                End If
            Catch ex As Exception
                reportInstances.Visible = False
            End Try
        End If
    End Sub
End Class
