﻿Imports System.IO
Imports System.Xml

Partial Class Results
    Inherits System.Web.UI.Page
    Private objReport As Report = Nothing

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        objReport = DirectCast(Session(Request.QueryString("id")), Report)
        'UpdateWebPortalUserMethod()
        timer.Enabled = False
        If Not objReport Is Nothing Then
            If File.Exists(Convert.ToString(objReport.OutputDirectory + objReport.IdentifyString + objReport.ReportName.Replace(" ", "")) & ".xml") Then



                '4/18/2019
                '2020.5p
                'New feature to append non-range parameter values to default filename


                Dim jsScript = "<script>window.open('ReportDirectory/" & Request.QueryString("id") & "/" & objReport.ReportName.Replace(" ", "") & Ctype(Session(objReport.IdentifyString & "-strParameterList"), String) & "." & objReport.FileExtension & "','_blank');</script>"
                If ismobile Then
                    jsScript = "<script>window.location.replace('ReportDirectory/" & Request.QueryString("id") & "/" & objReport.ReportName.Replace(" ", "") & CType(Session(objReport.IdentifyString & "-strParameterList"), String) & "." & objReport.FileExtension & "');</script>"
                End If












                Select Case objReport.DestinationType.ToLower()
                    Case "file"
                        lblMessage.Text = String.Empty
                        imgResults.ImageUrl = "images/rrReportCompleteScreen.gif"
                        'replace with correct image
                        btnReturn.Visible = True
                        ScriptManager.RegisterStartupScript(Me, GetType(Page), "pdfPopUp", jsScript, False)
                        Exit Select
                    Case "printer"
                        lblMessage.Text = Convert.ToString(objReport.ReportName) & " " & WebPortalResourceSet.GetResourceValue("ReportRunner", "SendTo", "sent to") & " " & Convert.ToString(objReport.DestinationFileName)
                        imgResults.ImageUrl = "images/rrReportCompleteScreen.gif"
                        'replace with correct image
                        btnReturn.Visible = True
                        Exit Select
                    Case "mail"
                        lblMessage.Text = Convert.ToString(objReport.ReportName) & " " & WebPortalResourceSet.GetResourceValue("ReportRunner", "SendTo", "sent to") & " " & Convert.ToString(objReport.DestinationFileName)
                        imgResults.ImageUrl = "images/rrReportCompleteEmail.gif"
                        'replace with correct image
                        btnReturn.Visible = True
                        Exit Select
                End Select
            ElseIf File.Exists(Convert.ToString(objReport.ErrorDirectory + objReport.IdentifyString + objReport.ReportName.Replace(" ", "")) & ".xml") Then
                lblMessage.Text = WebPortalResourceSet.GetResourceValue("ReportRunner", "GenerateReportError", "Error processing the report. Please contact system administrator or try again.")
                imgResults.ImageUrl = "images/rrReportError.gif"
                'Error Image
                btnReturn.Visible = True
            Else
                timer.Enabled = True
            End If
        End If
    End Sub

    Private Sub UpdateWebPortalUserMethod()
        'Checking webportal field is exist or not then updated
        Dim xdoc = XDocument.Load(objReport.TemplateDirectory + objReport.TemplateFileName)
        Dim rootElement = xdoc.Element("DocumentElement")
        Dim nodeElement = rootElement.Element("ReportRunnerBatchRecord")
        Dim webUserElement = nodeElement.Element("WebPortalUserName")
        Dim CurrentUser As String = CType(Session.Item("UserName"), String)
        Dim doc As New XmlDocument()
        doc.Load(objReport.TemplateDirectory + objReport.TemplateFileName)
        Dim node = doc.DocumentElement("ReportRunnerBatchRecord")
        If webUserElement Is Nothing Then
            Dim records As XmlElement = doc.CreateElement("WebPortalUserName")
            If CurrentUser Is Nothing Then
                records.InnerText = "jnnothing"
            Else
                records.InnerText = CurrentUser
            End If
            node.AppendChild(records)
            doc.Save(objReport.TemplateDirectory + objReport.TemplateFileName)
        Else
            If CurrentUser Is Nothing Then
                node("WebPortalUserName").InnerText = "jnnothing"
            Else
                node("WebPortalUserName").InnerText = CurrentUser
            End If

            doc.Save(objReport.TemplateDirectory + objReport.TemplateFileName)
        End If

    End Sub

    Protected Sub btnReturn_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnReturn.Click
        Response.Redirect("reportlist.aspx")
    End Sub

    Public Shared Function isMobileBrowser() As Boolean
        'GETS THE CURRENT USER CONTEXT
        Dim context As HttpContext = HttpContext.Current
        'FIRST TRY BUILT IN ASP.NT CHECK
        If context.Request.Browser.IsMobileDevice Then
            Return True
        End If
        'THEN TRY CHECKING FOR THE HTTP_X_WAP_PROFILE HEADER
        If context.Request.ServerVariables("HTTP_X_WAP_PROFILE") IsNot Nothing Then
            Return True
        End If
        'THEN TRY CHECKING THAT HTTP_ACCEPT EXISTS AND CONTAINS WAP
        If context.Request.ServerVariables("HTTP_ACCEPT") IsNot Nothing AndAlso context.Request.ServerVariables("HTTP_ACCEPT").ToLower().Contains("wap") Then
            Return True
        End If
        'AND FINALLY CHECK THE HTTP_USER_AGENT
        'HEADER VARIABLE FOR ANY ONE OF THE FOLLOWING
        If context.Request.ServerVariables("HTTP_USER_AGENT") IsNot Nothing Then
            'Create a list of all mobile types
            Dim mobiles() As String = {"midp", "j2me", "avant", "docomo", "novarra", "palmos", _
            "palmsource", "240x320", "opwv", "chtml", "pda", "windows ce", _
            "mmp/", "blackberry", "mib/", "symbian", "wireless", "nokia", _
            "hand", "mobi", "phone", "cdm", "up.b", "audio", _
            "SIE-", "SEC-", "samsung", "HTC", "mot-", "mitsu", _
            "sagem", "sony", "alcatel", "lg", "eric", "vx", _
            "NEC", "philips", "mmm", "xx", "panasonic", "sharp", _
            "wap", "sch", "rover", "pocket", "benq", "java", _
            "pt", "pg", "vox", "amoi", "bird", "compal", _
            "kg", "voda", "sany", "kdd", "dbt", "sendo", _
            "sgh", "gradi", "jb", "dddi", "moto", "iphone", "ipad", "android"}
            'Loop through each item in the list created above
            'and check if the header contains that text
            For Each s As String In mobiles
                If context.Request.ServerVariables("HTTP_USER_AGENT").ToLower().Contains(s.ToLower()) Then
                    Return True
                End If
            Next
        End If
        Return False
    End Function
    Dim ismobile = isMobileBrowser()
End Class
