﻿Imports System.IO

Partial Class JNAdmin_Settings
    Inherits System.Web.UI.Page
    Private Property SettingsSortDirection() As String
        Get
            Return TryCast(ViewState("SettingsSortDirection"), String)
        End Get
        Set(ByVal value As String)
            ViewState("SettingsSortDirection") = value
        End Set
    End Property
    Private Property SettingsSortExpression() As String
        Get
            Return TryCast(ViewState("SettingsSortExpression"), String)
        End Get
        Set(ByVal value As String)
            ViewState("SettingsSortExpression") = value
        End Set
    End Property
    Protected Sub Page_Init(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Init
        Dim actionHolder = ch_ContentHeader.ContentHeaderActionsHolder
        Dim btn As New Button()
        btn.ID = "btn_Refresh"
        btn.SkinID = "RefreshButton"
        AddHandler btn.Click, AddressOf btn_Refresh_Click
        btn.Text = WebPortalResourceSet.GetResourceValue("AdminSettings", "RefreshButton", "Refresh")
        actionHolder.Controls.Add(btn)
    End Sub
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        Dim templatedirectory = ConfigurationManager.AppSettings("templatedirectory")
        Dim picklistdirectory = ConfigurationManager.AppSettings("picklistdirectory")
        'Dim staticreportdirectory = ConfigurationManager.AppSettings("staticreportdirectory") '2020.5p - Not reading directly from web.config
        'Dim newrptfilesdirectory = ConfigurationManager.AppSettings("newrptfilesdirectory") '2020.5p - Not reading directly from web.config
        lblWebTemp.Text = templatedirectory
        lblParmPickList.Text = picklistdirectory
        lblStaticReport.Text = picklistdirectory.Replace("PickListDirectory\", "StaticReportDirectory\") '2020.5p - Added replace so ~ wasn't used
        lblNewRPT.Text = picklistdirectory.Replace("PickListDirectory\", "NewRPTFilesDirectory\") '2020.5p - Added replace so ~ wasn't used
        If Not IsPostBack Then
            gridView_Settings.AllowPaging = False
            gridView_Settings.AllowSorting = True
            SettingsSortExpression = "ScreenID"
            SettingsSortDirection = "ASC"
            LoadSettingsGrid()
            'divsucessMsg.InnerText = ""
        End If
        'divsucessMsg.InnerText = ""
    End Sub
    Private Sub LoadSettingsGrid()
        Dim _objLoadXml = New WebPortalResourceSet()
        Dim dataSource = _objLoadXml.SelectAll().DefaultView
        If SettingsSortExpression IsNot Nothing AndAlso SettingsSortDirection IsNot Nothing Then
            dataSource.Sort = SettingsSortExpression & " " & SettingsSortDirection
        Else
            dataSource.Sort = "ScreenID ASC"
        End If
        gridView_Settings.DataSource = dataSource
        gridView_Settings.DataBind()
    End Sub
    Protected Sub gridView_Settings_Sorting(ByVal sender As Object, ByVal e As GridViewSortEventArgs) Handles gridView_Settings.Sorting
        Dim sortDirection As String = "ASC"
        Dim sortExpression = SettingsSortExpression
        If sortExpression IsNot Nothing Then
            If sortExpression = e.SortExpression Then
                Dim lastDirection = SettingsSortDirection
                If (lastDirection IsNot Nothing) AndAlso (lastDirection = "ASC") Then
                    sortDirection = "DESC"
                End If
            End If
        End If
        SettingsSortDirection = sortDirection
        SettingsSortExpression = e.SortExpression
        LoadSettingsGrid()
    End Sub
    Protected Sub img_SettingsUpdateClick(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim btndetails As Button = TryCast(sender, Button)
        Dim ScreenID As String = btndetails.CommandArgument.ToString()
        Dim StringID As String = btndetails.CommandName.ToString()
        Dim stringDef As String = WebPortalResourceSet.GetResourceValue(ScreenID, StringID, "", False)
        txt_ScreenID.Text = ScreenID
        txt_StringID.Text = StringID
        txt_StringDef.Text = stringDef
        'divsucessMsg.Visible = False
        hdnModalVal.Value = "pnl_EditSetting"
        modal_EditSetting.Show()
    End Sub
    Protected Sub btn_SettingsUpdateClick(ByVal sender As Object, ByVal e As System.EventArgs)
        'divsucessMsg.Visible = False
        hdnModalVal.Value = "pnl_Setting"
        modal_Settings.Show()
    End Sub
    Protected Sub btn_EditSetting_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim _objLoadXml = New WebPortalResourceSet()
        _objLoadXml.Update(txt_ScreenID.Text, txt_StringID.Text, txt_StringDef.Text)
        LoadSettingsGrid()
        Dim sucess_Msg As String = WebPortalResourceSet.GetResourceValue("AdminSettings", "SettingsStringDefinitionUpdateMsg ", "String defintion updated successfully.")
        ScriptManager.RegisterClientScriptBlock(Me, Me.GetType(), "script4", "SucessMsg('" + sucess_Msg + "')", True)
        modal_EditSetting.Hide()
    End Sub
    Protected Sub btn_CSSSettingsUpdateClick(ByVal sender As Object, ByVal e As System.EventArgs)
        'divsucessMsg.Visible = False
        'ddl_AppThemes.SelectedValue = lbl_SiteCSS.Text
        'ddl_AppThemes_SelectedIndexChanged(sender, e)
        hdnModalVal.Value = "pnl_CSSSetting"
        modal_CSSSettings.Show()
    End Sub
    Protected Sub btn_Refresh_Click(ByVal sender As Object, ByVal e As EventArgs)
        WebPortalResourceSet.RefreshResource()
    End Sub
    Protected Sub btn_SaveUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_SaveUpdate.Click
        Dim errMsg As String
        If fuSiteLogo.HasFile Then
            Dim fileName = fuSiteLogo.FileName
            Dim extersion = Path.GetExtension(fileName).ToLower()
            If Not extersion.IsImageExternsion() Then
                errMsg = WebPortalResourceSet.GetResourceValue("AdminSettings", "SiteLogoFormatErrorTip", "the site logo must be image format")
                ScriptManager.RegisterClientScriptBlock(Me, Me.GetType(), "script4", "ErrorMsg('" + errMsg + "','msg_notify','msg_notifyClose')", True)
                modal_Settings.Show()
                Return
            End If
            Dim logoPath = "~/images/logo/" + fileName
            Dim localPath = Server.MapPath(logoPath)
            Directory.CreateDirectory(Path.GetDirectoryName(localPath))
            fuSiteLogo.SaveAs(localPath)
            Dim resource = New WebPortalResourceSet()
            resource.Update("AdminSettings", "SiteLogoUrl", logoPath)
        End If
        If fuSiteBackground.HasFile Then
            Dim fileName = fuSiteBackground.FileName
            Dim extersion = Path.GetExtension(fileName).ToLower()
            If Not extersion.IsImageExternsion() Then
                errMsg = WebPortalResourceSet.GetResourceValue("AdminSettings", "SiteBackgroundFormatErrorTip", "the site background must be image format")
                ScriptManager.RegisterClientScriptBlock(Me, Me.GetType(), "script4", "ErrorMsg('" + errMsg + "','msg_notify','msg_notifyClose')", True)
                modal_Settings.Show()
                Return
            End If
            Dim logoPath = "~/images/background/" + fileName
            Dim localPath = Server.MapPath(logoPath)
            Directory.CreateDirectory(Path.GetDirectoryName(localPath))
            fuSiteBackground.SaveAs(localPath)
            Dim resource = New WebPortalResourceSet()
            resource.Update("AdminSettings", "SiteBackgroundUrl", logoPath)
        End If
        '2013.5b - Bug fix to prevent saving .less file as .css
        'Dim temp As String = ConfigurationManager.AppSettings("pickcssfiles") + ddl_AppThemes.SelectedValue & ".css"
        'System.IO.File.WriteAllText(temp, txt_area.Value)
        Dim sucess_Msg As String = WebPortalResourceSet.GetResourceValue("AdminSettings", "SettingsDetailsUpdateMsg", "Settings details updated successfully.")
        ScriptManager.RegisterClientScriptBlock(Me, Me.GetType(), "script4", "SucessMsg('" + sucess_Msg + "')", True)
    End Sub
    Protected Sub btn_UpdateFooter_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_UpdateFooter.Click
        Dim temp As String = Server.MapPath("~/Footer.txt")
        System.IO.File.WriteAllText(temp, txt_FooterContent.Value)
        modal_EditFooter.Hide()
        Dim sucess_Msg As String = WebPortalResourceSet.GetResourceValue("AdminSettings", "SettingsDetailsUpdateMsg", "Settings details updated successfully.")
        ScriptManager.RegisterClientScriptBlock(Me, Me.GetType(), "script4", "SucessMsg('" + sucess_Msg + "')", True)
    End Sub
    Protected Sub btn_FooterClick(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim temp As String = Server.MapPath("~/Footer.txt")
        txt_FooterContent.Value = System.IO.File.ReadAllText(temp)
        'Dim sr As StreamReader
        'Dim temp As String = ConfigurationManager.AppSettings("pickcssfiles") + ddl_AppThemes.SelectedValue & ".css"
        'txt_FooterContent.Value = ""
        'sr = File.OpenText(temp)
        'While sr.Peek() <> -1
        'txt_FooterContent.Value = txt_FooterContent.Value + vbCrLf + sr.ReadLine()
        'End While
        'sr.Close()
        hdnModalVal.Value = "pnl_Footer"
        modal_EditFooter.Show()
    End Sub
    Protected Sub btn_TabsClick(ByVal sender As Object, ByVal e As System.EventArgs)
        'Dim headerSectionpath As String = Server.MapPath("~/HeaderSection.txt")
        Dim bodySectionpath As String = Server.MapPath("~/BodySection.txt")
        'txt_HeaderSection.Value = System.IO.File.ReadAllText(headerSectionpath)
        txt_BodySection.Value = System.IO.File.ReadAllText(bodySectionpath)
        hdnModalVal.Value = "pnl_Tabs"
        modal_EditTabs.Show()
    End Sub
    Protected Sub btn_UpdateTabs_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_UpdateTabs.Click
        Dim bodySectionpath As String = Server.MapPath("~/BodySection.txt")
        Dim bodytxt = System.IO.File.ReadAllText(bodySectionpath)
        Dim reportPagepath As String = Server.MapPath("~/ReportList.aspx")
        Dim reportRunnerPagepath As String = Server.MapPath("~/ReportRunner.aspx")
        Dim reportData As String = System.IO.File.ReadAllText(reportPagepath)
        Dim reportRunnerData As String = System.IO.File.ReadAllText(reportRunnerPagepath)
        If bodytxt IsNot "" AndAlso bodytxt.Length > 0 Then
            reportData = reportData.Replace(bodytxt, " ")
            reportRunnerData = reportRunnerData.Replace(bodytxt, " ")
        End If
        System.IO.File.WriteAllText(reportPagepath, reportData)
        System.IO.File.WriteAllText(reportRunnerPagepath, reportRunnerData)
        reportData = reportData.Replace("<%--BodySection--%>", txt_BodySection.Value + "<%--BodySection--%>")
        reportRunnerData = reportRunnerData.Replace("<%--BodySection--%>", txt_BodySection.Value + "<%--BodySection--%>")
        System.IO.File.WriteAllText(bodySectionpath, txt_BodySection.Value)
        System.IO.File.WriteAllText(reportPagepath, reportData)
        System.IO.File.WriteAllText(reportRunnerPagepath, reportRunnerData)
        modal_EditTabs.Hide()
        Dim sucess_Msg As String = WebPortalResourceSet.GetResourceValue("AdminSettings", "SettingsDetailsUpdateMsg", "Settings details updated successfully.")
        ScriptManager.RegisterClientScriptBlock(Me, Me.GetType(), "script4", "SucessMsg('" + sucess_Msg + "')", True)
    End Sub
    Protected Sub btn_Css_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_CssUpdate.Click
        Dim temp As String = ConfigurationManager.AppSettings("pickcssfiles") + ddl_AppThemes.SelectedValue & ".css"
        If System.IO.File.Exists(temp) Then
            System.IO.File.WriteAllText(temp, txt_area.Value)
        Else
            temp = ConfigurationManager.AppSettings("pickcssfiles") + ddl_AppThemes.SelectedValue & ".less"
            System.IO.File.WriteAllText(temp, txt_area.Value)
        End If
        Dim sucess_Msg As String = WebPortalResourceSet.GetResourceValue("AdminSettings", "SettingsDetailsUpdateMsg", "Settings details updated successfully.")
        ScriptManager.RegisterClientScriptBlock(Me, Me.GetType(), "script4", "SucessMsg('" + sucess_Msg + "')", True)
    End Sub
    Protected Sub ddl_AppThemes_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) 'Handles ddl_AppThemes.SelectedIndexChanged
        'Dim filelogo As FileUpload = fuSiteLogo
        'Dim filesiteBg As FileUpload = fuSiteBackground
        Dim str As String = fuSiteLogo.FileName
        If (ddl_AppThemes.SelectedIndex = 0) Then
            ' txt_area.Visible = False
            'lbl_CssContent.Visible = False
            txt_area.Value = ""
            'lbl_SiteCSS.Text = "JeffNetAdmin\Common"
            modal_CSSSettings.Show()
        End If
        If (ddl_AppThemes.SelectedIndex > 0) Then
            txt_area.Visible = True
            lbl_CssContent.Visible = True
            Dim sr As StreamReader
            Dim temp As String = ConfigurationManager.AppSettings("pickcssfiles") + ddl_AppThemes.SelectedValue & ".css"
            txt_area.Value = ""
            If System.IO.File.Exists(temp) Then
                sr = File.OpenText(temp)
            Else
                temp = ConfigurationManager.AppSettings("pickcssfiles") + ddl_AppThemes.SelectedValue & ".less"
                sr = File.OpenText(temp)
            End If
            While sr.Peek() <> -1
                txt_area.Value = txt_area.Value + vbCrLf + sr.ReadLine()
            End While
            sr.Close()
            'lbl_SiteCSS.Text = ddl_AppThemes.SelectedValue
            modal_CSSSettings.Show()
            'fuSiteLogo = filelogo
            'fuSiteBackground = filesiteBg
        End If
    End Sub
End Class
