# React and React Native, Fifth Edition
This is the code repository for [React and React Native, Fifth Edition](https://www.packtpub.com/product/react-and-react-native-fifth-edition/9781805127307), published by Packt.

**Build cross-platform JavaScript and TypeScript apps for the web, desktop, and mobile**

The authors of this book are -[Mikhail Sakhniuk](https://www.linkedin.com/in/m-sakhniuk) and [Adam Boduch](https://ca.linkedin.com/in/boduch)

## About the book

Welcome to your big-picture guide to the React ecosystem.

If you’re new to React and looking to become a professional React developer, this book is for you. This updated fifth edition reflects the current state of React, including React framework coverage as well as TypeScript.

Part 1 introduces you to React. You’ll discover JSX syntax, hooks, functional components, and event handling, learn techniques to fetch data from a server, and tackle the tricky problem of state management. Once you’re comfortable with writing React in JavaScript, you’ll pick up TypeScript development in later chapters.

Part 2 transitions you into React Native for mobile development. React Native goes hand-in-hand with React. With your React knowledge behind you, you’ll appreciate where and how React Native differs as you write shared components for Android and iOS apps. You’ll learn how to build responsive layouts, use animations, and implement geolocation.

By the end of this book, you’ll have a big-picture view of React and React Native and be able to build applications with both.


## Key Takeaways
- Explore React architecture, component properties, state, and context
- Work with React Hooks for handling functions and components
- Fetch data from a server using the Fetch API, GraphQL, and WebSockets
- Dive into internal and external state management strategies
- Build robust user interfaces (UIs) for mobile and desktop apps using Material-UI
- Perform unit testing for your components with Vitest and mocking
- Manage app performance with server-side rendering, lazy components, and Suspense


## Chapters

This unique book introduces both React and React Native, giving you a big picture view of the React ecosystem.

1. Why React?
2. Rendering with JSX
3. Understanding React Components and Hooks
4. Event Handling in the React Way
5. Crafting Reusable Components
6. Type-Checking and Validation with TypeScript
7. Handling Navigations with Routes
8. Code Splitting Using Lazy Components and Suspense
9. User Interface Framework Components
10. High-Performance State Updates
11. Fetching Data from a Server
12. State Management in React
13. Server-Side Rendering
14. Unit Testing in React
15. Why React Native?
16. React Native Under the Hood
17. Kick-Starting React Native Projects
18. Building Responsive Layouts with Flexbox
19. Navigating between Screens
20. Rendering Item Lists
21. Geolocation and Maps
22. Collecting User Input
23. Responding to User Gestures
24. Showing Progress
25. Displaying Modal Screens
26. Using Animations
27. Controlling Image Display
28. Going Offline




> If you feel this book is for you, get your [copy](https://www.amazon.in/React-Native-cross-platform-JavaScript-TypeScript-ebook/dp/B0CQTK654D/ref=sr_1_1?crid=2KR8KU1YBQP5E&dib=eyJ2IjoiMSJ9.o-Es1lhVSsnEs4VpLxSmUQ.AWi0NwC_D0brsleZA-mt6yDStZbezkRaYj9GuSB9mvM&dib_tag=se&keywords=9781805127307&qid=1713863818&sprefix=978-1805127307%2Caps%2C222&sr=8-1) today! <img alt="Coding" height="15" width="35"  src="https://media.tenor.com/ex_HDD_k5P8AAAAi/habbo-habbohotel.gif">


## Software and hardware list

This book assumes you have a basic understanding of the JavaScript programming language. It also assumes that you’ll be following along with the examples, which require a command-line terminal, a code editor, and a web browser. You’ll learn how to set up a React project in Chapter 1, Why React?.
The requirements for learning React Native are the same as for React development, but to run an app on a real device, you will need an Android or iOS smartphone. In order to run iOS apps in the simulator, you will need a Mac computer. To work with Android simulator, you can use any kind of PC.

| Chapter number     | Software required (With version)                                   | Free/Proprietary | If proprietary, can code testing be performed using a trial version | If proprietary, then cost of the software | Download links to the software                        | Hardware specifications                              | OS required           |
|--------------------|------------------------------------------------------------------------|-------------------|--------------------------------------------------------------------|-------------------------------------------|------------------------------------------------------|-----------------------------------------------------|-----------------------|
| Whole book         | Git                                                                    | Free              |                                                                        |                                           | [Download](https://git-scm.com/downloads)              | MacOS, Linux, Windows                               |
| Whole book         | Node.js                                                                | Free              |                                                                        |                                           | [Download](https://nodejs.org/en)                     | MacOS, Linux, Windows                               |
| Coding             | Visual Studio Code (VSCode)                                           | Free              |                                                                        |                                           | [Download](https://code.visualstudio.com/)           | MacOS, Linux, Windows                               |
| React chapters     | React                                                                  | Free              |                                                                        |                                           | [Download](https://react.dev/learn/start-a-new-react-project) | MacOS, Linux, Windows                               |
| React Native chapters | XCode (for iOS), Xcode line tools (for running simulator)             | Free              | Yes                                                                    |                                           | [MacOS App Store](#)                                 | Apple Mac (Macbook, iMac, MacMini)                  | MacOS                 |
| React Native chapters | Android Studio (for running simulator)                               | Free              | Yes                                                                    |                                           | [Download](https://developer.android.com/studio)      | MacOS, Linux, Windows                               |
| React Native chapters | Expo Go (Without simulator)                                           | Free              |                                                                        |                                           | [Play Store](https://play.google.com/store) or [App Store](https://apps.apple.com/us/app/expo-go/id982107779) | iPhone or any Android smartphone                    | iOS or Android        |


## Know more on the Discord server <img alt="Coding" height="25" width="32"  src="https://cliply.co/wp-content/uploads/2021/08/372108630_DISCORD_LOGO_400.gif">
You can get more engaged on the discord server for more latest updates and discussions in the community at [Discord](https://packt.link/ReactAndReactNative5e)

## Download a free PDF <img alt="Coding" height="25" width="40" src="https://emergency.com.au/wp-content/uploads/2021/03/free.gif">

_If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost. Simply click on the link to claim your free PDF._
[Free-Ebook](https://packt.link/free-ebook/9781805127307) <img alt="Coding" height="15" width="35"  src="https://media.tenor.com/ex_HDD_k5P8AAAAi/habbo-habbohotel.gif">

We also provide a PDF file that has color images of the screenshots/diagrams used in this book at [GraphicBundle](https://packt.link/gbp/9781805127307) <img alt="Coding" height="15" width="35"  src="https://media.tenor.com/ex_HDD_k5P8AAAAi/habbo-habbohotel.gif">


## Get to know the Authors
_Mikhail Sakhniuk_ is a seasoned software engineer skilled in TypeScript, React, and React Native. He has a decade of broad experience in the tech industry, with a specialized focus on frontend development for the past 7 years. His professional journey includes working with startups, fintech firms, and large product companies boasting over 50 million users. Currently, Mikhail is Principal Frontend Engineer at KappaPay.

_Adam Boduch_ has been involved in large-scale JavaScript development for nearly 15 years. Before moving to the frontend, he worked on several large-scale cloud computing products using Python and Linux. No stranger to complexity, Adam has practical experience with real-world software systems and the scaling challenges they pose.


## Other Related Books
- [React 18 Design Patterns and Best Practices - Fourth Edition](https://www.packtpub.com/product/react-18-design-patterns-and-best-practices-fourth-edition/9781803233109)
- [React Key Concepts](https://www.packtpub.com/product/react-key-concepts/9781803234502))
