<p align='center'><a href='https://www.packtpub.com/en-us/unlock?step=1'><img src='https://static.packt-cdn.com/assets/images/packt+events/finalGH_design_redeem.png'/></a></p>

<h1 align="center">
AI Agents in Practice, First Edition</h1>
<p align="center">This is the code repository for <a href ="ai-agents-in-practice-first-edition"> AI Agents in Practice, First Edition</a>, published by Packt.
</p>

<h2 align="center">
Design, Implement, and Scale Autonomous AI Systems for Production
</h2>
<p align="center">
Valentina Alto</p>

<p align="center">
   <a href="https://packt.link/z8ivB" alt="Discord" title="Learn more on the Discord server"><img width="32px" src="https://cliply.co/wp-content/uploads/2021/08/372108630_DISCORD_LOGO_400.gif"/></a>
  &#8287;&#8287;&#8287;&#8287;&#8287;
  <a href="https://packt.link/free-ebook/9781805801351"><img width="32px" alt="Free PDF" title="Free PDF" src="https://cdn-icons-png.flaticon.com/512/4726/4726010.png"/></a>
 &#8287;&#8287;&#8287;&#8287;&#8287;
  <a href="https://packt.link/gbp/9781805801351"><img width="32px" alt="Graphic Bundle" title="Graphic Bundle" src="https://cdn-icons-png.flaticon.com/512/2659/2659360.png"/></a>
  &#8287;&#8287;&#8287;&#8287;&#8287;
   <a href="https://www.amazon.com/Agents-Practice-Implement-Autonomous-Production/dp/180580135X"><img width="32px" alt="Amazon" title="Get your copy" src="https://cdn-icons-png.flaticon.com/512/15466/15466027.png"/></a>
  &#8287;&#8287;&#8287;&#8287;&#8287;
</p>
<details open> 
  <summary><h2>About the book</summary>
<a href="https://www.packtpub.com/product/unity-cookbook-fifth-edition/9781805123026">
<img src="https://content.packt.com/B32584/cover_image_small.jpg" alt="Unity Cookbook, Fifth Edition" height="256px" align="right">
</a>

In an era where AI agents are expected to operate autonomously and tackle complex tasks, AI Agents in Practice is your roadmap to building these next-generation systems. This book helps you go beyond simple chatbots and create AI agents that plan, reason, collaborate, and solve real-world problems using large language models and the latest open-source frameworks. You'll get a comparative tour of leading AI agent frameworks like LangChain and LangGraph, covering each tool's strengths, ideal use cases, and how to apply them in real projects. Through step-by-step examples, learn to construct single-agent and multi-agent architectures using proven design patterns to orchestrate AI agents working together. Case studies across industries show AI agents driving value in real scenarios, while guidance on responsible AI helps you implement ethical guardrails from day one. AI Agents in Practice also sets the stage with a brief history of AI agents; from early rule-based systems to today's LLM-driven autonomous agents—so you understand how we got here and where the field is headed. By the end, you'll have the practical skills, design insights, and ethical foresight to build and deploy AI agents that truly make an impact.
</details>
<details open> 
  <summary><h2>Key Learnings</summary>
<ul>

<li>Master core agent components like LLMs, memory systems, tool integration, and context management</li>

<li>Build production-ready AI agents using frameworks like LangChain with code</li>

<li>Create effective multi-agent systems using orchestration patterns for problem-solving</li>

<li>Implement industry-specific agents for e-commerce, customer support, and more</li>

<li>Design robust memory architectures for agents with short and long-term recall</li>

<li>Apply responsible AI practices with monitoring, guardrails, and human oversight</li>

<li>Optimize AI agent performance and cost for production environments</li>

</ul>

  </details>

<details open> 
  <summary><h2>Chapters</summary>


| Chapters | Colab | Kaggle | Gradient | Studio Lab |
| :-------- | :-------- | :------- | :-------- | :-------- |
| **Chapter 1: Evolution of AI workflows since November 2022** | | | | |
| **Chapter 2: The rise of AI Agents** | | | | |
| **Chapter 3: The need for an AI orchestrator** | | | | |
| **Chapter 4: The need for Memory and Context Management** | | | | |
| **Chapter 5: The need for Tools and External Integrations** | | | | |
| **Chapter 6: Building your first AI Agent with LangChain** | | | | |
| <ul><li>AIAgent.ipynb</li></ul> | <a href="https://colab.research.google.com/github/PacktPublishing/AI-Agents-in-Practice/blob/main/Chapter 6/AIAgent.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/PacktPublishing/AI-Agents-in-Practice/blob/main/Chapter 6/AIAgent.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/PacktPublishing/AI-Agents-in-Practice/blob/main/Chapter 6/AIAgent.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/PacktPublishing/AI-Agents-in-Practice/blob/main/Chapter 6/AIAgent.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| **Chapter 7: What happens if we put multiple AI Agents into the same room?** | | | | |
| <ul><li>multiagent.ipynb</li></ul> | <a href="https://colab.research.google.com/github/PacktPublishing/AI-Agents-in-Practice/blob/main/Chapter 7/multiagent.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a><br> | <a href="https://www.kaggle.com/kernels/welcome?src=https://github.com/PacktPublishing/AI-Agents-in-Practice/blob/main/Chapter 7/multiagent.ipynb"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a><br> | <a href="https://gradient.run/notebook/github.com/PacktPublishing/AI-Agents-in-Practice/blob/main/Chapter 7/multiagent.ipynb"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Open In Gradient"></a><br> | <a href="https://studiolab.sagemaker.aws/import/github/PacktPublishing/AI-Agents-in-Practice/blob/main/Chapter 7/multiagent.ipynb"><img src="https://studiolab.sagemaker.aws/studiolab.svg" alt="Open In Studio Lab"></a><br> |
| **Chapter 8: Responsible AI** | | | | |
| **Chapter 9: Conclusion** | | | | |






</details>


<details open> 
  <summary><h2>Requirements for this book</summary>
Here is a list of things you need to have: 
    
| **Software/hardware covered in the book** | **System requirements** |
|-------------------------------------------|---------------------------|
| **Python 3.10 or higher**                 | Windows, macOS, or Linux |
| **Node.js**                               | Windows, macOS, or Linux |
| **LLM chat and embedding models**         | Windows, macOS, or Linux  <br><br> You can decide to leverage your LLM of choice. Throughout the book, we will be using **GPT-4o** from **Azure OpenAI** or **OpenAI**. <br><br> Other options include (but are not limited to) the following:  <br> • Hugging Face Hub  <br> • Anthropic  <br> • Gemini |

  </details>
    


<details> 
  <summary><h2>Get to know Authors</h2></summary>

_Valentina Alto_ Valentina Alto is a technical architect specializing in AI and intelligent apps at Microsoft Innovation Hub in Dubai. During her tenure at Microsoft, she covered different roles as a solution specialist, focusing on data, AI, and applications workloads within the manufacturing, pharmaceutical, and retail industries and driving customers' digital transformations in the era of AI. Valentina is an active tech author and speaker who contributes to books, articles, and events on AI and machine learning. Over the past two years, Valentina has published two books on generative AI and large language models, further establishing her expertise in the field.



</details>
<details> 
  <summary><h2>Other Related Books</h2></summary>
<ul>

  <li><a href="https://www.packtpub.com/en-us/product/building-ai-agents-with-llms-rag-and-knowledge-graphs-first-edition/9781835087060">Building AI Agents with LLMs, RAG, and Knowledge Graphs, First Edition</a></li>

  <li><a href="https://www.packtpub.com/en-us/product/generative-ai-with-langchain-second-edition/9781837022014">Generative AI with LangChain, Second Edition</a></li>
 
</ul>

</details>
