<?php
/**
 * Admin header view
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div class="ipebo-top">
  <div class="ipebo-header">
    <div class="ipebo-page-title">
      <h4>
        <i class="dashicons-before dashicons-book-alt"></i>
        <span>
          <?php
          $title = IPEBO_TITLE;
          $words = explode( ' ', $title );
          $first = array_shift( $words );
          $title = implode( ' ', $words );
          ?>
          <strong><span><?php echo $first; ?></span> <?php echo $title; ?></strong>
          <em> <?php echo IPEBO_DESC; ?></em>
        </span>
      </h4>
    </div>
  </div>
  <div class="ipebo-nav">
    <ul>
    <?php
    $struct = $this->navStructure;
		$page   = $this->requestID;
    $title  = isset( $this->title ) ? $this->title : '';
    $info   = isset( $this->info ) ? $this->info : '';
    $icon   = isset( $this->icon ) ? $this->icon : '';
    if ( array_key_exists( $page, $struct ))
    {
      if ( empty( $title )) {
        $title = $struct[$page]['title'];
      }
      if ( empty( $info )) {
        $info  = $struct[$page]['info'];
      }
      if ( empty( $icon )) {
        $icon  = $struct[$page]['icon'];
      }
    }
    foreach( $struct as $name => $data )
    {
      $active = '';
      if ( $page == $name ) {
        $active = ' class="active"';
      }
      echo '<li' . $active . '>' .
              '<a href="admin.php?page=' . $name . '">' .
                  '<i class="dashicons-before dashicons-' . $data['icon'] . '"></i>' .
                  $data['title'] .
              '</a>' .
          '</li>';
    }
    ?>
    </ul>
  </div>
  <div class="ipebo-page-info">
    <i class="dashicons-before dashicons-<?php echo $icon; ?>"></i>
    <div class="ipebo-info">
      <h3><?php echo $title; ?></h3>
      <h4><?php echo $info; ?></h4>
    </div>
  </div>
</div>
