<?php
/**
 * Admin import content ebook view
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<!-- start: .ipebo-manage-wrap -->
<div class="ipebo-manage-wrap">

	<!-- start: .ipebo-form -->
  <form
  	id="ipebo-form-ebook-import"
  	class="ipebo-form-container ipebo-form"
  	method="post"
  	action="<?php echo $this->formAction; ?>"
  	enctype="multipart/form-data">

    <input
    	type="hidden"
    	name="object_id"
    	id="ipebo-value-objectid"
    	value="<?php echo $this->ebook->ID; ?>" />

      <!-- start: .container -->
      <div class="container-fluid container">

        <!-- start: .ipebo-manage-content -->
        <div class="ipebo-manage-content">

        <!-- start: .ipebo-import-main -->
        <div class="ipebo-import-main">
          <div class="row">

            <!-- start: .ipebo-import-filter -->
            <div class="col-md-4 ipebo-import-filter">

              <!-- start: .ipebo-import-search -->
              <div class="ipebo-import-widget ipebo-import-search">
                <h4><?php _e( 'Search', IPEBO_SLUG ); ?></h4>
                <div class="ipebo-import-search-form">
                  <div class="ipebo-import-search-field">
                    <input type="text" name="search_keyword" class="ipebo-import-search-input" value="">
                    <button type="submit" class="ipebo-import-search-submit">
                      <i class="ipebo-fa ipebo-fa-search"></i>
                    </button>
                    <span class="ipebo-import-search-loader" style="display:none;">
                      <i class="ipebo-fa ipebo-fa-spin ipebo-fa-spinner"></i>
                    </span>
                  </div>
                </div>
              </div>
              <!-- end: .ipebo-import-search -->

              <?php
              $cats = get_categories();
              if ( ! empty( $cats )) :
              ?>
              <!-- start: .ipebo-import-category -->
              <div class="ipebo-import-widget ipebo-import-category">
                <h4><?php _e( 'Filter By Category', IPEBO_SLUG ); ?></h4>

                <ul class="ipebo-import-category-list">
                  <?php
                  foreach( $cats as $cat ) :
                  ?>
                  <li>
                    <a href="#" data-id="<?php echo $cat->cat_ID; ?>" data-slug="<?php echo $cat->slug; ?>">
                      <i class="ipebo-fa ipebo-fa-check-circle"></i>
                      <strong><?php echo $cat->cat_name; ?></strong>
                    </a>
                  </li>
                  <?php
                  endforeach;
                  ?>
                </ul>
              </div>
              <!-- end: .ipebo-import-category -->
              <?php
              endif;
              ?>

            </div>
            <!-- end: .ipebo-import-filter -->

            <?php
            $args = array(
                'orderby'        => 'post_title',
                'order'          => 'ASC',
                'post_type'      => 'post',
                'post_status'    => array('publish','draft'),
                'posts_per_page' => -1
            );
            $query = new WP_Query;
            $posts = $query->query( $args );
            if ( ! empty( $posts )) :
            ?>
            <!-- start: .ipebo-import-posts -->
            <div class="col-md-8 ipebo-import-posts">
              <h4><?php _e( 'Posts Lists', IPEBO_SLUG ); ?></h4>

              <!-- start: .ipebo-import-posts-list -->
              <ul class="ipebo-import-posts-list">

                <?php
                foreach( $posts as $post ) :

                  $slugs = '';
                  $cats  = get_the_category( $post->ID );
                  if ( ! empty( $cats )) {
                    foreach( $cats as $cat ) {
                      $slugs .= ' category-' . $cat->slug;
                    }
                    $catIds = trim( $slugs );
                  }
                ?>
                <!-- start: .ipebo-import-post -->
                <li class="ipebo-import-post <?php echo $slugs; ?>">
                  <a href="#" data-id="<?php echo $post->ID; ?>">
                    <i class="ipebo-fa ipebo-fa-check-circle"></i>
                    <strong><?php echo $post->post_title; ?></strong>
                  </a>
                </li>
                <!-- end: .ipebo-import-post -->
                <?php
                endforeach;
                ?>

              </ul>
              <!-- end: .ipebo-import-posts-list -->

            </div>
            <!-- end: .ipebo-import-posts -->
            <?php
            endif;
            ?>

          </div>
        </div>
        <!-- end: .ipebo-import-main -->






          <!-- start: .ipebo-manage-footer -->
          <div class="ipebo-manage-footer mt25">
            <!-- start: .row -->
            <div class="row">

              <!-- start: .col-md-6 -->
              <div class="col-md-6">
                <div class="ipebo-bottom-submit">
                  <button
                    type="submit"
                    class="ipebo-form-submit ipebo-btn ipebo-btn-secondary ipebo-btn-lg ipebo-ebook-import-submit"
                    id="do-update-bottom"
                    name="update_bottom">
                    <strong><?php _e( 'Next Step', IPEBO_SLUG ); ?></strong>
                    <i class="ipebo-fa ipebo-fa-chevron-right ml10"></i>
                  </button>
                </div>
              </div>
              <!-- end: .col-md-6 -->

              <!-- start: .col-md-6 -->
              <div class="col-md-6">
              </div>
              <!-- end: .col-md-6 -->

            </div>
            <!-- end: .row -->
          </div>
          <!-- end: .ipebo-manage-footer -->

        </div>
        <!-- end: .ipebo-manage-content -->
      </div>
      <!-- end: .container -->
    </form>
    <!-- start: .ipebo-form -->
  </div>
  <!-- end: .ipebo-manage-wrap -->

  <?php
  $this->view( 'main/import-modal-error', 'admin' );
  $this->view( 'main/import-modal-failed', 'admin' );
  $this->view( 'main/modal-loader', 'admin' );
  ?>
