<?php
/**
 * Field content cover view
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>

<!-- start: .ipebo-form-field-type -->
<div id="ipebo-form-field-cover" class="ipebo-form-field-type" style="display:none;">

  <!-- start: .ipebo-field-row -->
  <div class="ipebo-field-row ipebo-field-y ipebo-help-abs">
    <div class="ipebo-form-label">
      <label for="input-title"><?php _e( 'Title', IPEBO_SLUG ); ?></label>
    </div>

    <!-- start: .ipebo-field -->
    <div class="ipebo-field">
      <input type="text" class="ipebo-input ipebo-input-full ipebo-input-content-title" name="cover_title" value="">

      <div class="ipebo-help">
        <a class="ipebo-btn-help ipebo-btn ipebo-btn-default" href="#"><i class="ipebo-fa ipebo-fa-question"></i></a>
        <div class="ipebo-help-content ipebo-hide">
          <?php _e( 'Set the ebook cover title.', IPEBO_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipebo-field -->
  </div>
  <!-- end: .ipebo-field-row -->

  <!-- start: .ipebo-field-row -->
  <div class="ipebo-field-row ipebo-field-y ipebo-help-abs">
    <div class="ipebo-form-label">
      <label for="input-summary"><?php _e( 'Summary', IPEBO_SLUG ); ?></label>
    </div>

    <!-- start: .ipebo-field -->
    <div class="ipebo-field">
      <?php
      wp_editor( '', 'cover_summary', array(
        'editor_height' => 100,
        'media_buttons' => false,
        'teeny'         => true,
        'quicktags'     => false,
        'tinymce'       => array(
          'toolbar1' => 'bold italic | underline strikethrough | link'
        )
      ));
      ?>

      <div class="ipebo-help">
        <a class="ipebo-btn-help ipebo-btn ipebo-btn-default" href="#"><i class="ipebo-fa ipebo-fa-question"></i></a>
        <div class="ipebo-help-content ipebo-hide">
          <?php _e( 'Set the ebook cover summary.', IPEBO_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipebo-field -->
  </div>
  <!-- end: .ipebo-field-row -->

  <?php
  //
  //Field Image
  $this->renderFieldImage(array(
    'name'			 => 'cover_image',
    'label' 		 => 'Main Image',
    'inputValue' => '',
    'info'		   => 'Set the main image of the page cover.',
    'layout'     => 'vertical',
    'fieldOptions' => array(
      'fieldId'  => 'ipebo-field-cover-image'
    )
  ));
  //
  //Field Image
  $this->renderFieldImage(array(
    'name'			 => 'cover_logo',
    'label' 		 => 'Logo',
    'inputValue' => '',
    'info'		   => 'Set the logo of the page cover.',
    'layout'     => 'vertical',
    'fieldOptions' => array(
      'fieldId'  => 'ipebo-field-cover-logo'
    )
  ));
  ?>

</div>
<!-- end: .ipebo-form-field-type -->
