<?php
/**
 * Admin create ebook view
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<!-- start: .ipebo-manage-wrap -->
<div class="ipebo-manage-wrap">

	<!-- start: .ipebo-form -->
  <form
  	id="ipebo-form-ebook-create"
  	class="ipebo-form-container ipebo-form"
  	method="post"
  	action="<?php echo $this->formAction; ?>"
  	enctype="multipart/form-data">

    <input
    	type="hidden"
    	name="object_id"
    	id="ipebo-value-objectid"
    	value="0" />

    <!-- start: .container -->
    <div class="container-fluid container">

      <!-- start: .ipebo-manage-content -->
      <div class="ipebo-manage-content">

        <!-- start: .ipebo-manage-fields -->
        <div class="ipebo-manage-fields">

          <?php
          //
          //Field Text
          $this->renderFieldText(array(
          	'name'			 => 'ebook_title',
          	'label' 		 => 'Title',
          	'inputValue' => '',
          	'info'		   => 'Set the ebook title. This data will not be used directly in creating ebook, only to mark the ebook, so it easier for you to manage it.'
          ));

          //
          //Field Info
          $this->renderFieldTextarea(array(
          	'name'			 => 'ebook_info',
          	'label' 		 => 'Info',
          	'inputValue' => '',
          	'info'		   => 'Set the ebook info. This data will not be used directly in creating ebook, only to mark the ebook, so it easier for you to manage it.'
          ));

          //
          //Field resource
          $options = array(
            'blank'   => array(
              'name'  => 'blank',
              'value' => 'blank',
              'label' => __( 'Blank', IPEBO_SLUG ),
              'icon'  => 'ipebo-fa ipebo-fa-file-o'
            ),
            'post'   => array(
              'name'  => 'post',
              'value' => 'post',
              'label' => __( 'Post', IPEBO_SLUG ),
              'icon'  => 'ipebo-fa ipebo-fa-pencil'
            )
          );
          ?>

        </div>
        <!-- end: .ipebo-manage-fields -->

        <!-- start: .ipebo-manage-footer -->
        <div class="ipebo-manage-footer mt25">
          <!-- start: .row -->
          <div class="row">

            <!-- start: .col-md-6 -->
            <div class="col-md-6">
              <div class="ipebo-bottom-submit">
                <button
                  type="submit"
                  class="ipebo-form-submit ipebo-btn ipebo-btn-secondary ipebo-btn-lg ipebo-ebook-edit-submit"
                  id="do-update-bottom"
                  name="update_bottom">
                  <i class="ipebo-fa ipebo-fa-plus-circle"></i>
                  <strong><?php _e( 'Create Ebook', IPEBO_SLUG ); ?></strong>
                </button>
              </div>
            </div>
            <!-- end: .col-md-6 -->

            <!-- start: .col-md-6 -->
            <div class="col-md-6">
            </div>
            <!-- end: .col-md-6 -->

          </div>
          <!-- end: .row -->
        </div>
        <!-- end: .ipebo-manage-footer -->

      </div>
      <!-- end: .ipebo-manage-content -->
    </div>
    <!-- end: .container -->
  </form>
  <!-- start: .ipebo-form -->
</div>
<!-- end: .ipebo-manage-wrap -->
