<?php
/**
 * Class ebook model
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Model_Ebook' ))
{
  /**
   * Class for manage main setting
   */
  class IPEbo_Model_Ebook extends IPEbo_Model
  {
    //{{ parameters

    /**
     * Take setting name
     *
     * @var string
     */
    protected $_settingName = '__ipebo_ebook_setting';

    //}}
    //{{ saveSettings

    /**
     * Save setting
     *
     * @return void
     */
    public function saveSettings()
    {
      $data   = $this->_getSettingData();
      $result = update_option( $this->_settingName, $data );
      return $result;
    }

    //}}
    //{{ getSettings

    /**
     * Get setting
     *
     * @return IPEbo_Config
     */
    public function getSettings()
    {
      $settings = array();
      $data     = get_option( $this->_settingName );
      if ( ! empty( $data ))
      {
        $settings = maybe_unserialize( $data );
      }
      $result = new IPEbo_Config( $settings );
      return $result;
    }

    //}}
    //{{ _getSettingStructure

    /**
     * Get setting structure
     *
     * @return array
     */
    protected function _getSettingStructure()
    {
      $structure = array(
        'ebook_resource'    => 'term',
        'ebook_posts'       => 'title',
        'restricted'        => 'term',
        'content_layout'    => 'int',
        'bgimage'           => 'int',
        'page_bgcolor'      => 'title',
        'content_bgcolor'   => 'title',
        'title_color'       => 'title',
        'content_color'     => 'title',
        'title_font'        => 'term',
        'content_font'      => 'term',
        'cover_title'       => 'title',
        'cover_summary'     => 'content',
        'cover_image'       => 'int',
        'cover_logo'        => 'int'
      );
      return $structure;
    }
  }
}
?>
