<?php
if ( ! class_exists( 'IPEbo_Font' ))
{
  /**
   * Class for create popup
   */
  class IPEbo_Font
  {
    /**
     * Get option font
     *
     * @return array
     */
    public static function getOptions()
    {
      $options = array(
        'serif' => array(
          'dejavuserif'           => 'DeJaVu Serif',
          'dejavuserifcondensed'  => 'DeJaVu Condensed',
          'freeserif'             => 'Free Serif',
          'droid_serif'           => 'Droid Serif',
          'playfair_display'      => 'Playfair Display'
        ),
        'sans-serif' => array(
          'dejavusans'          => 'DeJaVu Sans',
          'dejavusanscondensed' => 'DeJaVu Sans Condensed',
          'freesans'            => 'Free Sans',
          'lato'                => 'Lato',
          'roboto'              => 'Roboto'
        ),
        'monospace' => array(
          'dejavusansmono'  => 'DeJaVu Sans Mono',
          'freemono'        => 'Free Mono'
        ),
        'cursive' => array(
          'chewy'           => 'Chewy',
          'comfortaa'       => 'Comfortaa',
          'lobster'         => 'Lobster',
          'oleoscript'      => 'Oleo Script'
        )
      );
      return $options;
    }

    /**
     * Get font name
     *
     * @return array
     */
    public static function getFontName( $key )
    {
      $name    = 'Font';
      $options = self::getOptions();
      foreach( $options as $gid => $items )
      {
        foreach( $items as $id => $label )
        {
          if ( $key == $id ) {
            $name = $label;
          }
        }
      }
      return $name;
    }
  }
}
