<?php
/**
 * Class helper for create admin page
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Admin' ))
{
	class IPEbo_Admin extends IPEbo_Form
	{
		//{{ parameters

		/**
		 * Take post setting
		 *
		 * @var array
		 */
		protected $_settings;

		/**
		 * Take view path
		 *
		 * @var string
		 */
		protected $_viewPath;

		/**
		 * Take config object
		 *
		 * @access protected
		 * @var array
		 */
		protected $_config;

		/**
		 * Take request ID
		 *
		 * @var string
		 */
		public $requestID;

		//}}
		//{{ __construct

		/**
		 * Class construct
		 *
		 * @param array $config
		 * @return void
		 */
		public function __construct( $config = array() )
		{
			$this->_settings = $config;
			$this->_viewPath = IPEBO_VIEW;
			$this->_setConfig( $config );

			//General pre process
			$this->_preProcess();
		}

		//}}
		//{{ render

		/**
		 * Render admin page
		 *
		 * @return void
		 */
		public function render()
		{
			echo $this->build();
		}

		//}}
		//{{ build

		/**
		 * Build admin page
		 *
		 * @return void
		 */
		public function build()
		{
			$this->_setViewData();
			$this->view( 'container' );
		}

		//}}
		//{{ header

		/**
		 * Build header admin page
		 *
		 * @return void
		 */
		public function header()
		{
			$this->_setNavStructure();
			$this->view( 'header' );
		}

		//}}
		//{{ pageMessage

		/**
		 * Build message in top of page
		 *
		 * @return void
		 */
		public function pageMessage()
		{
		}

		//}}
		//{{ topButtonAction

		/**
		 * Build button actions in top of page
		 *
		 * @return void
		 */
		public function topButtonActions()
		{
		}

		//}}
		//{{ main

		/**
		 * Main content
		 *
		 * @return void
		 */
		public function main()
		{
		}

		//}}
		//{{ view

		/**
		 * Get admin view file
		 *
		 * @param string $filename
		 * @return void
		 */
		public function view( $filename, $type = 'system' )
		{
			$path  = $this->_viewPath;
			if ( $type == 'admin' ) {
				$path .= 'admin/';
			} else {
				$path .= 'admin/system/';
			}
			$path .= strtolower( $filename ) . '.php';
			if ( file_exists( $path )) {
				include( $path );
			}
		}

		//}}
		//{{ config

		/**
		 * Get config object
		 *
		 * @return IPEbo_Config
		 */
	  public function config()
		{
			return $this->_config;
		}

		//}}
		//{{ _setConfig

		/**
		 * _setConfig
		 *
		 * @param array $config
		 * @return void
		 */
	  protected function _setConfig( $config = array() )
		{
			$this->_config = new IPEbo_Config( $config );
		}

		//}}
		//{{ _setViewData

		/**
		 * Set view data
		 *
		 * @return void
		 */
		protected function _setViewData()
		{
			$this->htmlRootID = 'ipebo-admin';
		}

		//}}
		//{{ _preProcess

		/**
		 * Pre processing request
		 *
		 * @return void
		 */
	  protected function _preProcess()
		{
		}

		//}}
		//{{ _setNavStructure

		/**
		 * Set navigation structure
		 *
		 * @return void
		 */
		protected function _setNavStructure()
		{
			$pageMain    = IPEBO_PAGENAME;
			$pageCreate  = IPEBO_PAGENAME . '-create';
			$struct 		 = array(
		    $pageMain => array(
          'title'     => __( 'All Ebooks', IPEBO_SLUG ),
          'info'      => __( 'Manage all ebooks', IPEBO_SLUG ),
          'icon'      => 'book-alt'
		     ),
		    $pageCreate 	=> array(
          'title'     => __( 'Create Ebook', IPEBO_SLUG ),
          'info'      => __( 'Create new ebook', IPEBO_SLUG ),
          'icon'      => 'plus'
		     )
			 );
			$this->navStructure = $struct;
		}

		//
		//
		//Helper
		//

		//}}
		//{{ htmlMessage

		/**
		 * Build html message
		 *
		 * @param  string  $message
		 * @param  string  $type
		 * @return void
		 */
		public function htmlMessage( $message, $type = 'success' )
		{
			$msg = '<div class="ipebo-alert ipebo-alert-' . $type . '" style="display: block;">' .
								__( $message, IPEBO_SLUG ) .
							'</div>';

			echo $msg;
		}

		//}}
		//{{ htmlButtonAdd

		/**
		 * Build html message
		 *
		 * @param  string  $label
		 * @param  string  $page
		 * @param  string  $action
		 * @return void
		 */
		public function htmlButtonAdd( $label, $page, $action )
		{
			$link   = admin_url() . 'admin.php?page=' . $page . '&action=' . $action;
			$button = '<div class="_add-button mb30">' .
									'<a href="' . $link . '" class="ipebo-btn ipebo-btn-success ipebo-btn-sm _add-page">' .
										'<i class="ipebo-fa ipebo-fa-plus-circle"></i>' .
										__( $label, IPEBO_SLUG ) .
									'</a>' .
								'</div>';

			echo $button;
		}

		//}}
	}
}
