<?php
/**
 * Controller to handling importing posts
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Ajax_Import_posts' ))
{
  class IPEbo_Ajax_Import_posts
  {
    /**
     * Execution save options process
     *
     * @return void
     */
    public function exec()
    {
      $result = false;
      $item   = false;
      $id     = 0;
      if ( ! empty( $_REQUEST['ebookid'] )) {
        $id   = absint( $_REQUEST['ebookid'] );
        $item = get_post( $id );
      }

      if ( $item )
      {
        $model = new IPEbo_Model_Ebook();
				$model->saveSetting( $id );
        $result = true;

        //Save item post
        if ( ! empty( $_POST['ebook_posts'] ))
        {
          $_posts = apply_filters( 'single_post_title', $_POST['ebook_posts'] );
          $_posts = trim( $_posts, '|' );
          $ids    = explode( '|', $_posts );

          foreach( $ids as $id )
          {
            $id   = absint( $id );
            $post = get_post( $id );
            if ( $post )
            {
              $settings = new IPEbo_Setting( $post->ID, '__ipebo_ebook_page_setting' );
              $settings->setSetting( 'page_type', 'article' );
            }
          }
        }
      }

      if ( $result )
      {
        echo json_encode( array(
          'status'   => 1,
          'message'  => __( 'Successfully import posts', IPEBO_SLUG ),
          'redirect' => admin_url() . 'admin.php?page=' . IPEBO_PAGENAME . '&action=edit&id=' . $id
        ) );
      }
      else {
        echo json_encode( array(
          'status'  => 0,
          'message' => __( 'Failed import posts.', IPEBO_SLUG )
        ) );
      }
      die();
    }
  }
}
