<?php
/**
 * Controller to handling get ebook page data
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Ajax_Get_page' ))
{
  class IPEbo_Ajax_Get_page
  {
    /**
     * Execution ajax process
     *
     * @return void
     */
    public function exec()
    {
      $ebook = $page = false;
      if ( ! empty( $_POST['ebookid'] )) {
        $ebookId = absint( $_POST['ebookid'] );
        $ebook   = get_post( $ebookId );
      }
      if ( ! empty( $_POST['pageid'] )) {
        $pageId = absint( $_POST['pageid'] );
        $page   = get_post( $pageId );
      }

      if ( ! $ebook || ! $page ) {
        echo json_encode( array(
          'status'        => 0,
          'messageTitle'  => __( 'System Error', IPEBO_SLUG ),
          'message'       => __( 'System Error', IPEBO_SLUG )
        ) );
        die();
      }

      $data = array(
        'type'      => 'page',
        'id'        => $page->ID,
        'ebook'     => $ebook,
        'page'      => $page
      );

      //
      //Set settings
      $settings = new IPEbo_Setting( $page->ID, '__ipebo_ebook_page_setting' );

      //Page type
      $pageType = $settings->getSetting( 'page_type', 'article' );
      $data['page_type'] = $pageType;

      if ( $pageType == 'article' ) {
        $data = $this->_getContentArticle( $data, $page, $settings );
      }
      else if ( $pageType == 'table' ) {
        $data = $this->_getContentTable( $data, $page, $settings );
      }
      else if ( $pageType == 'action' ) {
        $data = $this->_getContentAction( $data, $page, $settings );
      }

      //Layout
      $data['content_layout'] = $settings->getSetting( 'content_layout', 1 );

      //Page Background color
      $data['page_bgcolor'] = $settings->getSetting( 'page_bgcolor', '#eeeeee' );

      //Content Background color
      $data['content_bgcolor'] = $settings->getSetting( 'content_bgcolor', '#ffffff' );

      //Title color
      $data['title_color'] = $settings->getSetting( 'title_color', '#000000' );

      //Content color
      $data['content_color'] = $settings->getSetting( 'content_color', '#333333' );

      //Background Image
      $bgImageId  = 0;
      $bgImageUrl = '';
      if ( $imgId = $settings->getSetting( 'bgimage' ) )
      {
        $dataimg    = wp_get_attachment_image_src( $imgId, 'thumbnail' );
        $bgImageId  = $imgId;
        $bgImageUrl = $dataimg[0];
      }
      $data['bgimage_id']  = $bgImageId;
      $data['bgimage_url'] = $bgImageUrl;

      //Title font
      $data['title_font'] = $settings->getSetting( 'title_font', 'playfair_display' );

      //Content font
      $data['content_font'] = $settings->getSetting( 'content_font', 'roboto' );

      //Get preview
      $preview = $this->_getPreview( $page, $settings );

      echo json_encode( array(
        'status'        => 1,
        'messageTitle'  => __( 'Success', IPEBO_SLUG ),
        'message'       => __( 'Successfully get ebook data.', IPEBO_SLUG ),
        'data'          => $data,
        'preview'       => $preview
      ) );
      die();

    }

    /**
     * Get content article
     *
     * @param  array  $data
     * @param  object $page
     * @param  object $settings
     * @return void
     */
    protected function _getContentArticle( $data, $page, $settings )
    {
      //Title
      $data['article_title']   = stripslashes( $page->post_title );
      //Summary
      $data['article_summary'] = stripslashes( $page->post_excerpt );
      //Content
      $data['article_content'] = stripslashes( $page->post_content );
      //Author
      $data['article_author']  = $settings->getSetting( 'article_author' );

      return $data;
    }

    /**
     * Get content table
     *
     * @param  array  $data
     * @param  object $page
     * @param  object $settings
     * @return void
     */
    protected function _getContentTable( $data, $page, $settings )
    {
      //Title
      $data['table_title']   = stripslashes( $page->post_title );
      //Content
      $data['table_content'] = stripslashes( $page->post_content );

      return $data;
    }

    /**
     * Get content action
     *
     * @param  array  $data
     * @param  object $page
     * @param  object $settings
     * @return void
     */
    protected function _getContentAction( $data, $page, $settings )
    {
      //Title
      $data['action_title']           = stripslashes( $page->post_title );
      //Content
      $data['action_content']         = stripslashes( $page->post_content );
      //Button label
      $data['action_button_label']    = stripslashes( $settings->getSetting( 'action_button_label' ) );
      //Button url
      $data['action_button_url']      = $settings->getSetting( 'action_button_url' );
      //Button template
      //$data['action_button_template'] = $settings->getSetting( 'action_button_template', 1 );
      //Button color
      $data['action_button_color']    = $settings->getSetting( 'action_button_color', 'clean' );
      //Button size
      $data['action_button_size']     = $settings->getSetting( 'action_button_size', 'md' );

      return $data;
    }

    /**
     * Get preview
     *
     * @param  object $page
     * @param  object $settings
     * @return void
     */
    protected function _getPreview( $page, $settings )
    {
      $creator  = new IPEbo_Creator_Content( $page, $settings, false, true );
      $content  = $creator->getPageContent();
      return $content;
    }
  }
}
