<?php
/**
 * Controller to handling get ebook data for cover
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Ajax_Get_ebook_cover' ))
{
  class IPEbo_Ajax_Get_ebook_cover
  {
    /**
     * Execution ajax process
     *
     * @return void
     */
    public function exec()
    {
      $ebook = false;
      if ( ! empty( $_POST['ebookid'] )) {
        $ebookId = absint( $_POST['ebookid'] );
        $ebook   = get_post( $ebookId );
      }

      if ( ! $ebook ) {
        echo json_encode( array(
          'status'        => 0,
          'messageTitle'  => __( 'System Error', IPEBO_SLUG ),
          'message'       => __( 'System Error', IPEBO_SLUG )
        ) );
        die();
      }

      $data = array(
        'type'      => 'cover',
        'id'        => $ebook->ID,
        'ebook'     => $ebook
      );
      //
      //Set settings
      $settings = new IPEbo_Setting( $ebook->ID, '__ipebo_ebook_setting' );

      //Title
      $data['cover_title']   = stripslashes( $ebook->post_title );
      //Summary
      $data['cover_summary'] = stripslashes( $ebook->post_content );

      //Cover image
      $imageId  = 0;
      $imageUrl = '';
      if ( $imgId = $settings->getSetting( 'cover_image' ) )
      {
        $dataimg  = wp_get_attachment_image_src( $imgId, 'thumbnail' );
        $imageId  = $imgId;
        $imageUrl = $dataimg[0];
      }
      $data['image_id']  = $imageId;
      $data['image_url'] = $imageUrl;

      //Cover logo
      $logoId  = 0;
      $logoUrl = '';
      if ( $imgId = $settings->getSetting( 'cover_logo' ) )
      {
        $dataimg = wp_get_attachment_image_src( $imgId, 'thumbnail' );
        $logoId  = $imgId;
        $logoUrl = $dataimg[0];
      }
      $data['logo_id']  = $logoId;
      $data['logo_url'] = $logoUrl;

      //Layout
      $data['content_layout'] = $settings->getSetting( 'content_layout', 1 );

      //Page Background color
      $data['page_bgcolor'] = $settings->getSetting( 'page_bgcolor', '#eeeeee' );

      //Content Background color
      $data['content_bgcolor'] = $settings->getSetting( 'content_bgcolor', '#ffffff' );

      //Title color
      $data['title_color'] = $settings->getSetting( 'title_color', '#000000' );

      //Content color
      $data['content_color'] = $settings->getSetting( 'content_color', '#333333' );

      //Background Image
      $bgImageId  = 0;
      $bgImageUrl = '';
      if ( $imgId = $settings->getSetting( 'bgimage' ) )
      {
        $dataimg    = wp_get_attachment_image_src( $imgId, 'thumbnail' );
        $bgImageId  = $imgId;
        $bgImageUrl = $dataimg[0];
      }
      $data['bgimage_id']  = $bgImageId;
      $data['bgimage_url'] = $bgImageUrl;

      //Title font
      $data['title_font'] = $settings->getSetting( 'title_font', 'playfair_display' );

      //Content font
      $data['content_font'] = $settings->getSetting( 'content_font', 'roboto' );

      //Get preview
      $preview = $this->_getPreview( $ebook, $settings );

      echo json_encode( array(
        'status'        => 1,
        'messageTitle'  => __( 'Success', IPEBO_SLUG ),
        'message'       => __( 'Successfully get ebook data.', IPEBO_SLUG ),
        'data'          => $data,
        'preview'       => $preview
      ) );
      die();

    }

    /**
     * Get preview
     *
     * @param  object $ebook
     * @param  object $settings
     * @return void
     */
    protected function _getPreview( $ebook, $settings )
    {
      $creator  = new IPEbo_Creator_Content( $ebook, $settings, true, true );
      $content  = $creator->getCoverContent();
      return $content;
    }
  }
}
