<?php
/**
 * Controller to handling deleting ebook process
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Ajax_Delete_ebook' ))
{
  class IPEbo_Ajax_Delete_ebook
  {
    /**
     * Execution save options process
     *
     * @return void
     */
    public function exec()
    {
      $item = false;
      if ( ! empty( $_REQUEST['id'] )) {
        $id   = absint( $_REQUEST['id'] );
        $item = get_post( $id );
      }
      if ( ! $item ) {
        echo json_encode( array(
          'status'   => 0,
          'message'  => __( 'Error system', IPEBO_SLUG )
        ) );
        die();
      }
      $result = wp_delete_post( $item->ID, true );
      if ( $result ) {
        echo json_encode( array(
          'status'   => 1,
          'message'  => __( 'Ebook successfully deleted', IPEBO_SLUG ),
          'redirect' => admin_url() . 'admin.php?page=' . IPEBO_PAGENAME . '&delete=1'
        ) );
      } else {
        echo json_encode( array(
          'status'  => 0,
          'message' => __( 'Failed to remove the ebook', IPEBO_SLUG )
        ) );
      }
      die();
    }
  }
}
