<?php
/**
 * Field design view
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>

<!-- start: .ipebo-edit-fields -->
<div id="ipebo-edit-fields-design" class="ipebo-edit-fields" style="display:none;">
  <div class="ipebo-edit-fields-inner">

    <div class="ipebo-form-section">

      <!-- start: .ipebo-form-fields -->
      <div class="ipebo-form-fields">

        <?php
        $fieldOptions = array(
          'labelClass' => 'ipebo-form-label col-lg-4 col-md-5 col-sm-12',
          'inputClass' => 'ipebo-field col-lg-8 col-md-7 col-sm-12'
        );
        //
        //Field Color
        $this->renderFieldColor(array(
          'name'			 => 'page_bgcolor',
          'label' 		 => 'Page Background Color',
          'inputValue' => '#ffffff',
          'info'		   => 'Set the background color of ebook page.',
          'fieldOptions' => $fieldOptions
        ));
        //
        //Field Color
        $this->renderFieldColor(array(
          'name'			 => 'content_bgcolor',
          'label' 		 => 'Content Background Color',
          'inputValue' => '#ffffff',
          'info'		   => 'Set the background color of content page.',
          'fieldOptions' => $fieldOptions
        ));
        //
        //Field Image
        $this->renderFieldImage(array(
          'name'			 => 'bgimage',
          'label' 		 => 'Background Image',
          'inputValue' => '',
          'info'		   => 'Set the image of the page background.',
          'layout'     => 'vertical',
          'fieldOptions' => array(
            'fieldId'  => 'ipebo-field-bgimage'
          )
        ));
        //
        //Field Title Color
        $this->renderFieldColor(array(
          'name'			 => 'title_color',
          'label' 		 => 'Title Color',
          'inputValue' => '#000000',
          'info'		   => 'Set the title color.',
          'fieldOptions' => $fieldOptions
        ));
        //
        //Field Content Color
        $this->renderFieldColor(array(
          'name'			 => 'content_color',
          'label' 		 => 'Content Color',
          'inputValue' => '#333333',
          'info'		   => 'Set the content color.',
          'fieldOptions' => $fieldOptions
        ));
        //
        //Field Title Font
        $this->renderFieldFontFamily(array(
          'name'			 => 'title_font',
          'label' 		 => 'Title Font',
          'inputValue' => 'roboto',
          'info'		   => 'Set the font family of the title.',
          'fieldOptions' => array(
            'labelClass' => 'ipebo-form-label col-lg-4 col-md-5 col-sm-12',
            'inputClass' => 'ipebo-field col-lg-8 col-md-7 col-sm-12',
            'fieldId'    => 'ipebo-field-title-font'
          )
        ));
        //
        //Field Content Font
        $this->renderFieldFontFamily(array(
          'name'			 => 'content_font',
          'label' 		 => 'Content Font',
          'inputValue' => 'roboto',
          'info'		   => 'Set the font family of the content.',
          'fieldOptions' => array(
            'labelClass' => 'ipebo-form-label col-lg-4 col-md-5 col-sm-12',
            'inputClass' => 'ipebo-field col-lg-8 col-md-7 col-sm-12',
            'fieldId'    => 'ipebo-field-content-font'
          )
        ));
        ?>

      </div>
      <!-- end: .ipebo-form-fields -->

      <!-- start: .ipebo-form-fields -->
      <div class="ipebo-form-submit ipebo-field-actions">
        <button type="submit" class="ipebo-btn-shadow ipebo-btn-shadow-primary ipebo-btn-shadow-md ipebo-edit-page-submit">
          <span class="ipebo-btn-shadow-inner">
            <i class="ipebo-fa ipebo-fa-floppy-o"></i>
            <?php _e( 'Save Change', IPEBO_SLUG ); ?>
          </span>
        </button>
      </div>
      <!-- end: .ipebo-form-submit -->

    </div>

  </div>
</div>
<!-- end: .ipebo-edit-fields -->
