<?php
/**
 * Field content table view
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>

<!-- start: .ipebo-form-field-type -->
<div id="ipebo-form-field-table" class="ipebo-form-field-type" style="display:none;">

  <!-- start: .ipebo-field-row -->
  <div class="ipebo-field-row ipebo-field-y ipebo-help-abs">
    <div class="ipebo-form-label">
      <label for="input-title"><?php _e( 'Title', IPEBO_SLUG ); ?></label>
    </div>

    <!-- start: .ipebo-field -->
    <div class="ipebo-field">
      <input type="text" class="ipebo-input ipebo-input-full ipebo-input-content-title" name="table_title" value="">

      <div class="ipebo-help">
        <a class="ipebo-btn-help ipebo-btn ipebo-btn-default" href="#"><i class="ipebo-fa ipebo-fa-question"></i></a>
        <div class="ipebo-help-content ipebo-hide">
          <?php _e( 'Set the ebook section title.', IPEBO_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipebo-field -->
  </div>
  <!-- end: .ipebo-field-row -->

  <!-- start: .ipebo-field-row -->
  <div class="ipebo-field-row ipebo-field-y ipebo-help-abs">
    <div class="ipebo-form-label">
      <label for="input-content"><?php _e( 'Main Content', IPEBO_SLUG ); ?></label>
    </div>

    <!-- start: .ipebo-field -->
    <div class="ipebo-field">
      <?php
      wp_editor( '', 'table_content', array(
        'editor_height' => 100,
        'teeny'         => true,
        'quicktags'     => false,
        'tinymce'       => array(
          'toolbar1' => 'bold italic | paragraph | underline strikethrough | indent outdent | bullist numlist | link'
        )
      ));
      ?>

      <div class="ipebo-help">
        <a class="ipebo-btn-help ipebo-btn ipebo-btn-default" href="#"><i class="ipebo-fa ipebo-fa-question"></i></a>
        <div class="ipebo-help-content ipebo-hide">
          <?php _e( 'Set the ebook section content.', IPEBO_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipebo-field -->
  </div>
  <!-- end: .ipebo-field-row -->

</div>
<!-- end: .ipebo-form-field-type -->
