<?php
/**
 * Field content article view
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>

<!-- start: .ipebo-form-field-type -->
<div id="ipebo-form-field-article" class="ipebo-form-field-type">

  <!-- start: .ipebo-field-row -->
  <div class="ipebo-field-row ipebo-field-y ipebo-help-abs">
    <div class="ipebo-form-label">
      <label for="input-title"><?php _e( 'Title', IPEBO_SLUG ); ?></label>
    </div>

    <!-- start: .ipebo-field -->
    <div class="ipebo-field">
      <input type="text" class="ipebo-input ipebo-input-full ipebo-input-content-title" name="article_title" value="">

      <div class="ipebo-help">
        <a class="ipebo-btn-help ipebo-btn ipebo-btn-default" href="#"><i class="ipebo-fa ipebo-fa-question"></i></a>
        <div class="ipebo-help-content ipebo-hide">
          <?php _e( 'Set the ebook section title.', IPEBO_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipebo-field -->
  </div>
  <!-- end: .ipebo-field-row -->

  <!-- start: .ipebo-field-row -->
  <div class="ipebo-field-row ipebo-field-y ipebo-help-abs">
    <div class="ipebo-form-label">
      <label for="input-author"><?php _e( 'Author', IPEBO_SLUG ); ?></label>
    </div>

    <!-- start: .ipebo-field -->
    <div class="ipebo-field">
      <input type="text" class="ipebo-input ipebo-input-full ipebo-input-content-author" name="article_author" value="">

      <div class="ipebo-help">
        <a class="ipebo-btn-help ipebo-btn ipebo-btn-default" href="#"><i class="ipebo-fa ipebo-fa-question"></i></a>
        <div class="ipebo-help-content ipebo-hide">
          <?php _e( 'Set the ebook section author.', IPEBO_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipebo-field -->
  </div>
  <!-- end: .ipebo-field-row -->

  <!-- start: .ipebo-field-row -->
  <div class="ipebo-field-row ipebo-field-y ipebo-help-abs">
    <div class="ipebo-form-label">
      <label for="input-summary"><?php _e( 'Summary', IPEBO_SLUG ); ?></label>
    </div>

    <!-- start: .ipebo-field -->
    <div class="ipebo-field">
      <?php
      wp_editor( '', 'article_summary', array(
        'editor_height' => 100,
        'media_buttons' => false,
        'teeny'         => true,
        'quicktags'     => false,
        'tinymce'       => array(
          'toolbar1' => 'bold italic | underline strikethrough | link'
        )
      ));
      ?>

      <div class="ipebo-help">
        <a class="ipebo-btn-help ipebo-btn ipebo-btn-default" href="#"><i class="ipebo-fa ipebo-fa-question"></i></a>
        <div class="ipebo-help-content ipebo-hide">
          <?php _e( 'Set the ebook section summary.', IPEBO_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipebo-field -->
  </div>
  <!-- end: .ipebo-field-row -->

  <!-- start: .ipebo-field-row -->
  <div class="ipebo-field-row ipebo-field-y ipebo-help-abs">
    <div class="ipebo-form-label">
      <label for="input-content"><?php _e( 'Main Content', IPEBO_SLUG ); ?></label>
    </div>

    <!-- start: .ipebo-field -->
    <div class="ipebo-field">
      <?php
      wp_editor( '', 'article_content', array(
        'editor_height' => 100,
        'teeny'         => true,
        'quicktags'     => false,
        'tinymce'       => array(
          'toolbar1' => 'bold italic | paragraph | underline strikethrough | indent outdent | bullist numlist | link'
        )
      ));
      ?>

      <div class="ipebo-help">
        <a class="ipebo-btn-help ipebo-btn ipebo-btn-default" href="#"><i class="ipebo-fa ipebo-fa-question"></i></a>
        <div class="ipebo-help-content ipebo-hide">
          <?php _e( 'Set the ebook section content.', IPEBO_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipebo-field -->
  </div>
  <!-- end: .ipebo-field-row -->

</div>
<!-- end: .ipebo-form-field-type -->
