<?php
/**
 * Admin dashboard view
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<!-- start: .ipebo-admin-full -->
<div id="ipebo-page-ebook-edit" class="ipebo-admin-full ipebo-page">
  <!-- start: .ipebo-page-inner -->
  <div class="ipebo-page-inner">
    <!-- start: .ipebo-page-main -->
    <div class="ipebo-page-main">

      <!-- start: .ipebo-edit-header -->
      <div class="ipebo-edit-header">
        <h4 class="ipebo-edit-title">
          <i class="dashicons-before dashicons-book-alt"></i>
          <?php
          $title = IPEBO_TITLE;
          $words = explode( ' ', $title );
          $first = array_shift( $words );
          $title = implode( ' ', $words );
          ?>
          <strong><span><?php echo $first; ?></span> <?php echo $title; ?></strong>
        </h4>
      </div>
      <!-- end: .ipebo-edit-header -->

      <!-- start: .ipebo-edit-main -->
      <div class="ipebo-edit-main">
      <div class="ipebo-edit-main-inner">

        <form
        	id="ipebo-form-ebook-edit-page"
        	class="ipebo-form-container ipebo-form"
        	method="post"
        	action="#"
        	enctype="multipart/form-data">

          <input
          	type="hidden"
          	name="object_id"
          	id="ipebo-value-objectid"
          	value="<?php echo $this->ebook->ID; ?>" />

          <input
          	type="hidden"
          	name="page_id"
          	id="ipebo-value-pageid"
          	value="" />

          <input
          	type="hidden"
          	name="object_type"
          	id="ipebo-value-object-type"
          	value="" />

          <input
          	type="hidden"
          	name="page_type"
          	id="ipebo-value-page-type"
          	value="" />

        <!-- start: .ipebo-edit-main-top -->
        <div class="ipebo-edit-main-top">
          <div class="container container-fluid">
            <div class="row">
              <div class="col-md-4">

                <!-- start: .ipebo-edit-back -->
                <div class="ipebo-edit-back">
                  <a href="<?php echo admin_url() . 'admin.php?page=' . IPEBO_PAGENAME; ?>">
                    <i class="ipebo-fa ipebo-fa-home"></i>
                    <?php _e( 'Back to dashboard', IPEBO_SLUG ); ?>
                  </a>
                </div>
                <!-- end: .ipebo-edit-back -->

              </div>
              <div class="col-md-8">

                <!-- start: .ipebo-edit-actions -->
                <div class="ipebo-edit-actions">
                  <?php
                  $previewUrl = admin_url() . 'admin.php?page=' . IPEBO_PAGENAME . '&action=preview&id=' . $this->ebook->ID;
                  ?>
                  <a href="<?php echo $previewUrl; ?>" class="ipebo-btn-shadow ipebo-btn-shadow-secondary ipebo-btn-shadow-md ipebo-edit-action-preview" target="_blank">
                    <span class="ipebo-btn-shadow-inner">
                      <i class="ipebo-fa ipebo-fa-eye"></i>
                      <?php _e( 'Preview PDF', IPEBO_SLUG ); ?>
                    </span>
                  </a>
                  <a href="#" class="ipebo-btn-shadow ipebo-btn-shadow-primary ipebo-btn-shadow-md ipebo-edit-action-save">
                    <span class="ipebo-btn-shadow-inner">
                      <i class="ipebo-fa ipebo-fa-floppy-o"></i>
                      <?php _e( 'Save Ebook', IPEBO_SLUG ); ?>
                    </span>
                  </a>
                  <?php
                  /*
                  <a href="#" class="ipebo-btn-shadow ipebo-btn-shadow-success ipebo-btn-shadow-md ipebo-edit-action-settings">
                    <span class="ipebo-btn-shadow-inner">
                      <i class="ipebo-fa ipebo-fa-bars"></i>
                      <?php _e( 'Settings', IPEBO_SLUG ); ?>
                    </span>
                  </a>
                  */
                  ?>
                </div>
                <!-- end: .ipebo-edit-actions -->

              </div>
            </div>
          </div>
        </div>
        <!-- end: .ipebo-edit-main-top -->

        <!-- start: .ipebo-edit-content -->
        <div class="ipebo-edit-content">
          <div class="container container-fluid">
            <div class="row">
              <!-- start: .ipebo-edit-form -->
              <div class="col-md-5 ipebo-edit-form">

                <div class="ipebo-edit-form-inner">

                  <!-- start: .ipebo-edit-tabs -->
                  <div class="ipebo-edit-tabs">
                    <ul>
                      <li>
                        <a href="#ipebo-edit-fields-pages" class="_active">
                          <?php _e( 'Pages', IPEBO_SLUG ); ?>
                        </a>
                      </li>
                      <li class="ipebo-edit-inactive">
                        <a href="#ipebo-edit-fields-content">
                          <?php _e( 'Content', IPEBO_SLUG ); ?>
                        </a>
                      </li>
                      <li class="ipebo-edit-inactive">
                        <a href="#ipebo-edit-fields-layout">
                          <?php _e( 'Layout', IPEBO_SLUG ); ?>
                        </a>
                      </li>
                      <li class="ipebo-edit-inactive">
                        <a href="#ipebo-edit-fields-design">
                          <?php _e( 'Design', IPEBO_SLUG ); ?>
                        </a>
                      </li>
                    </ul>
                  </div>
                  <!-- end: .ipebo-edit-tabs -->

                  <!-- start: .ipebo-edit-tabs-content -->
                  <div class="ipebo-edit-tabs-content">

                    <?php
                    $this->view( 'main/edit/fields-pages', 'admin' );
                    $this->view( 'main/edit/fields-content', 'admin' );
                    $this->view( 'main/edit/fields-layout', 'admin' );
                    $this->view( 'main/edit/fields-design', 'admin' );
                    ?>

                  </div>
                  <!-- end: .ipebo-edit-tabs-content -->

                </div>

              </div>
              <!-- end: .ipebo-edit-form -->

              <!-- start: .ipebo-edit-preview -->
              <div class="col-md-7 ipebo-edit-preview">
                <div class="ipebo-edit-preview-inner">
                  <div class="ipebo-edit-preview-main"></div>
                  <div class="ipebo-edit-preview-none">
                    <?php _e( 'Please select a page.', IPEBO_SLUG ); ?>
                  </div>
                </div>
              </div>
              <!-- end: .ipebo-edit-preview -->

            </div>
          </div>
        </div>
        <!-- end: .ipebo-edit-content -->

        </form>

      </div>
      </div>
      <!-- end: .ipebo-edit-main -->

    </div>
    <!-- end: .ipebo-page-main -->
  </div>
  <!-- end: .ipebo-page-inner -->
</div>
<!-- end: .ipebo-admin-full -->

<?php
//Modal delete confirm
$this->view( 'main/edit/modal-delete-confirm', 'admin' );

//Modal add page
$this->view( 'main/edit/modal-add-page', 'admin' );

//Modal failed
$this->view( 'main/edit/modal-failed', 'admin' );
//Modal success
$this->view( 'main/edit/modal-success', 'admin' );
//Modal loader
$this->view( 'main/modal-loader', 'admin' );
