<?php
if ( ! class_exists( 'IPEbo_Viewer' ))
{
  /**
   * Viewer class
   *
   * @package wp-ebook-creator
   * @author InstaProduct
   * @link http://insta-product.com/
   */

  class IPEbo_Viewer
  {
    //{{ dashboard

    /**
     * Dashboard viewer
     *
     * @return void
     */
    public function dashboard()
    {
      $this->pageId = IPEBO_PAGENAME;

      //Edit slideshow
      if ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' )
      {
        if ( empty( $_GET['id'] )) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPEBO_SLUG ) );
        }
        $id = absint( $_GET['id'] );
        if ( ! $box = get_post( $id ) ) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPEBO_SLUG ) );
        }
        $this->_manageBoxes( $box );
      }
      //Create box
      else if ( isset( $_GET['action'] ) && $_GET['action'] == 'createbox' )
      {
        $this->_manageBox();
      }
      //Edit box
      else if ( isset( $_GET['action'] ) && $_GET['action'] == 'editbox' )
      {
        if ( empty( $_GET['id'] )) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPEBO_SLUG ) );
        }
        $id = absint( $_GET['id'] );
        if ( ! $box = get_post( $id ) ) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPEBO_SLUG ) );
        }
        $this->_manageBox( $box );
      }
      //Widget dashboard
      else {
        $this->view( 'admin/dashboard' );
      }
    }

    //}}
    //{{ create

    /**
     * Create widget viewer
     *
     * @return void
     */
    public function create()
    {
      $this->pageId = IPEBO_PAGENAME . '-create';
			$this->_manageBoxes();
    }

    //}}
    //{{ _manageBoxes

    /**
     * Manage boxes
     *
     * @param object $box
     * @return void
     */
    protected function _manageBoxes( $box = false )
    {
      //
      //Including script
      wp_enqueue_media();
      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

      $boxId = 0;
      if ( $box ) {
        $boxId = $box->ID;
      }
      $setting    = new IPEbo_Setting( $boxId, '__ipebo_boxes_setting' );
      $formAction = admin_url( 'admin-ajax.php' ) . '?doajax=1&ipebo=1&action=update_boxes';
      if ( $box )
      {
        $pageTitle   = __( 'Edit Slideshow', IPEBO_SLUG );
        $submitLabel = __( 'Save Change', IPEBO_SLUG );
        $submitId    = 'ipebo-edit-boxes';
        $formId      = 'ipebo-form-boxes-update';
        $submitIcon  = 'floppy-o';
        $pageId      = IPEBO_PAGENAME;

      } else
      {
        $pageTitle   = __( 'Add Slideshow', IPEBO_SLUG );
        $submitLabel = __( 'Add Slideshow', IPEBO_SLUG );
        $submitId    = 'ipebo-add-boxes';
        $formId      = 'ipebo-form-boxes-add';
        $submitIcon  = 'plus-circle';
        $pageId      = IPEBO_PAGENAME . '-create';
      }
      $this->pageId      = $pageId;
      $this->pageTitle   = $pageTitle;
      $this->submitLabel = $submitLabel;
      $this->submitId    = $submitId;
      $this->formId      = $formId;
      $this->submitIcon  = $submitIcon;
      $this->setting     = $setting;
      $this->box         = $box;
      $this->boxId       = $boxId;
      $this->formAction  = $formAction;
      $this->styles      = $this->_getStyles();
      $this->slides      = $this->_getSlides();

      $tab = 'ipebo-section-general';
      if ( ! empty( $_REQUEST['tab'] )) {
        $tab = $_REQUEST['tab'];
      }
      $this->tab = $tab;

      //Render view
      $this->view( 'admin/main/main' );
    }

    //}}
    //{{ _manageBox

    /**
     * Manage box
     *
     * @param object $box
     * @return void
     */
    protected function _manageBox( $box = false )
    {
      //
      //Including script
      wp_enqueue_media();
      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

      $boxId = 0;
      if ( $box ) {
        $boxId = $box->ID;
      }
      $setting    = new IPEbo_Setting( $boxId, '__ipebo_box_setting' );
      $formAction = admin_url( 'admin-ajax.php' ) . '?doajax=1&ipebo=1&action=update_box';
      if ( $box )
      {
        $pageTitle   = __( 'Edit Box', IPEBO_SLUG );
        $submitLabel = __( 'Save Change', IPEBO_SLUG );
        $submitId    = 'ipebo-edit-box';
        $formId      = 'ipebo-form-box-update';
        $submitIcon  = 'floppy-o';
        $pageId      = IPEBO_PAGENAME;

      } else
      {
        $pageTitle   = __( 'Add Box', IPEBO_SLUG );
        $submitLabel = __( 'Add Box', IPEBO_SLUG );
        $submitId    = 'ipebo-add-box';
        $formId      = 'ipebo-form-box-add';
        $submitIcon  = 'plus-circle';
        $pageId      = IPEBO_PAGENAME;
      }
      $this->pageId      = $pageId;
      $this->pageTitle   = $pageTitle;
      $this->submitLabel = $submitLabel;
      $this->submitId    = $submitId;
      $this->formId      = $formId;
      $this->submitIcon  = $submitIcon;
      $this->setting     = $setting;
      $this->box         = $box;
      $this->boxId       = $boxId;
      $this->formAction  = $formAction;

      $slideId = 0;
      if ( ! empty( $_GET['slide_id'] ) ) {
        $slideId = absint( $_GET['slide_id'] );
      }
      $this->slideId = $slideId;

      $tab = 'ipebo-section-general';
      if ( ! empty( $_REQUEST['tab'] )) {
        $tab = $_REQUEST['tab'];
      }
      $this->tab = $tab;

      //Render view
      $this->view( 'admin/box/main' );
    }

    //}}
    //{{ style

    /**
     * Style page viewer
     *
     * @return void
     */
    public function style()
    {
      $this->pageId = IPEBO_PAGENAME . '-style';

      //Edit style
      if ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' )
      {
        if ( empty( $_GET['id'] )) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPEBO_SLUG ) );
        }
        $id = absint( $_GET['id'] );
        if ( ! $style = get_post( $id ) ) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPEBO_SLUG ) );
        }
        $this->_manageStyle( $style );
      }
      //Create new box
      elseif ( isset( $_GET['action'] ) && $_GET['action'] == 'create' )
      {
        $this->_manageStyle();
      }
      //Style dashboard
      else {
        $this->view( 'admin/style' );
      }
    }

    //}}
    //{{ _manageStyle

    /**
     * Manage style
     *
     * @param object $style
     * @return void
     */
    protected function _manageStyle( $style = false )
    {
      //
      //Including script
      wp_enqueue_media();
      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

      $styleId = 0;
      if ( $style ) {
        $styleId = $style->ID;
      }
      $setting    = new IPEbo_Setting( $styleId, '__ipebo_style_setting' );
      $formAction = admin_url( 'admin-ajax.php' ) . '?doajax=1&ipebo=1&action=update_style';
      if ( $style )
      {
        $pageTitle   = __( 'Edit Style', IPEBO_SLUG );
        $submitLabel = __( 'Save Change', IPEBO_SLUG );
        $submitId    = 'ipebo-edit-style';
        $formId      = 'ipebo-form-style-update';
        $submitIcon  = 'floppy-o';
        $pageId      = IPEBO_PAGENAME . '-style';

      } else
      {
        $pageTitle   = __( 'Add Style', IPEBO_SLUG );
        $submitLabel = __( 'Add Style', IPEBO_SLUG );
        $submitId    = 'ipebo-add-style';
        $formId      = 'ipebo-form-style-add';
        $submitIcon  = 'plus-circle';
        $pageId      = IPEBO_PAGENAME . '-style';
      }
      $this->pageId      = $pageId;
      $this->pageTitle   = $pageTitle;
      $this->submitLabel = $submitLabel;
      $this->submitId    = $submitId;
      $this->formId      = $formId;
      $this->submitIcon  = $submitIcon;
      $this->setting     = $setting;
      $this->style       = $style;
      $this->styleId     = $styleId;
      $this->formAction  = $formAction;

      $tab = 'ipebo-section-general';
      if ( ! empty( $_REQUEST['tab'] )) {
        $tab = $_REQUEST['tab'];
      }
      $this->tab = $tab;

      //Render view
      $this->view( 'admin/style/main' );
    }

    //}}}
    //{{{ shortcodeBackend

    /**
     * Shortcode backend viewer
     *
     * @return string
     */
    public function shortcodeBackend()
    {
			$this->slides = $this->_getSlides();
      //Render view
      $this->view( 'admin/shortcode' );
    }

    //}}
    //{{ setting

    /**
     * Setting page viewer
     *
     * @return void
     */
    public function setting()
    {
      $this->pageId = IPEBO_PAGENAME . '-setting';
      $this->boxes  = $this->_getBoxes();
      //Render view
      $this->view( 'admin/setting' );
    }

    //}}
    //{{ view

    /**
     * Get admin view file
     *
     * @param string $filename
     * @return void
     */
    public function view( $filename )
    {
      $path  = IPEBO_VIEW;
      $path .= strtolower( $filename ) . '.php';
      if ( file_exists( $path )) {
        include( $path );
      }
    }

    //}}
    //{{ _getStyles

    /**
     * Get styles list
     *
     * @return array
     */
    protected function _getStyles()
    {
      $args = array(
        'orderby'        => 'post_title',
        'order'          => 'ASC',
        'post_type'      => 'ipebo_style',
        'post_status'    => array('publish'),
        'posts_per_page' => -1,
        'paged'          => 1
      );
      $query  = new WP_Query;
      $styles = $query->query( $args );
      return $styles;
    }

    //}}
    //{{ _getSlides

    /**
     * Get slideshows list
     *
     * @return array
     */
    protected function _getSlides()
    {
      $args = array(
        'orderby'        => 'post_title',
        'order'          => 'ASC',
        'post_type'      => 'ipebo_boxes',
        'post_status'    => array('publish'),
        'posts_per_page' => -1,
        'paged'          => 1
      );
      $query  = new WP_Query;
      $slides = $query->query( $args );
      return $slides;
    }

    //}}
  }
}
