<?php
/**
 * Class model
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Model' )) {

  /**
   * Class for manage post setting
   */
  class IPEbo_Model
  {
    //{{ parameters

    /**
     * Take setting name
     *
     * @var string
     */
    protected $_settingName;

    //}}
    //{{ saveSetting

    /**
     * Save setting style
     *
     * @param  int $id
     * @return void
     */
    public function saveSetting( $id )
    {
      $id       = absint( $id );
      $data     = $this->_getSettingData();
      $setting  = new IPEbo_Setting( $id, $this->_settingName );
      $result   = $setting->setSettings( $data );
      return $result;
    }

    //}}
    //{{ _getSettingData

    /**
     * Get setting data
     *
     * @return array
     */
    protected function _getSettingData()
    {
      $setting = array();
      $data    = array_merge( $_POST, $_GET );
      $strucs  = $this->_getSettingStructure();

      foreach( $strucs as $key => $method )
      {
        if ( isset( $data[$key] ))
        {
          if ( $method == 'term' ) {
            $setting[$key] = apply_filters( 'pre_term_name', $data[$key] );
          }
          else if ( $method == 'title' ) {
            $setting[$key] = apply_filters( 'single_post_title', $data[$key] );
          }
          else if ( $method == 'int' ) {
            $setting[$key] = absint( $data[$key] );
          }
          else if ( $method == 'email' ) {
            $setting[$key] = sanitize_email( $data[$key] );
          }
          else if ( $method == 'link' ) {
            $setting[$key] = apply_filters( 'pre_link_url', $data[$key] );
          }
          else if ( $method == 'content' ) {
            $setting[$key] = apply_filters( 'wp_filter_kses', $data[$key] );
          }
          else {
            $setting[$key] = $data[$key];
          }
        }
      }
      return $setting;
    }

    //}}
    //{{ _getSettingStructure

    /**
     * Get setting structure
     *
     * @return array
     */
    protected function _getSettingStructure()
    {
      $structure = array();
      return $structure;
    }
  }
}
?>
