<?php
/**
 * Class for create list ebook
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_List_Ebook' ))
{
  class IPEbo_List_Ebook extends IPEbo_List
  {
    //{{ _getData

    /**
     * Get data
     *
     * @return void
     */
    protected function _getData()
    {
      $page     = $this->_page;
      $per_page = $this->_perPage;
      $args = array(
          'orderby'        => 'post_date',
          'order'          => 'DESC',
          'post_type'      => 'ipebo_ebook',
          'post_status'    => array('publish','draft'),
          'posts_per_page' => $per_page,
          'paged'          => $page
      );
      $query = new WP_Query;
      $this->_result = $query->query( $args );
      $this->_query  = $query;
      $this->_total  = $query->found_posts;
      $this->_total_page = $this->_getTotalPage();
      return $this->_result;
    }

    //}}
    //{{ _getItemAction

    /**
     * Get item action
     *
     * @param  object $item
     * @param  int    $index
     * @return string
     */
    protected function _getItemAction( $item, $index )
    {
      $itemId     = $this->_getListItemId( $item );
      $previewUrl = admin_url() . 'admin.php?page=' . IPEBO_PAGENAME . '&action=preview&id=' . $itemId;
      $result     =
        '<div class="col-sm-6">' .
          '<div class="ipebo-item-action ipebo-clear text-right">' .
            $this->_getItemStat( $item, $index ) .

            '<div class="ipebo-item-nav ipebo-fademenu">' .
              '<div class="ipebo-fademenu-inner">' .
                '<div class="ipebo-nav-label ipebo-fademenu-button">' .
                  '<a class="ipebo-menu-link" href="#"><i class="ipebo-fa ipebo-fa-bars"></i></a>' .
                '</div>' .
                '<ul class="ipebo-submenu ipebo-fademenu-content">' .
                  '<li>' .
                    '<a href="' . $previewUrl . '" class="ipebo-btn ipebo-btn-xs ipebo-btn-secondary">' .
                      '<i class="ipebo-fa ipebo-fa-eye"></i>' .
                       __( 'Preview Ebook', IPEBO_SLUG ) .
                    '</a>' .
                  '</li>' .
                  '<li>' .
                    '<a href="' . $this->_getLinkEdit( $item ) . '" class="ipebo-btn ipebo-btn-xs ipebo-btn-success">' .
                      '<i class="ipebo-fa ipebo-fa-pencil"></i>' .
                       __( 'Edit Ebook', IPEBO_SLUG ) .
                    '</a>' .
                  '</li>' .
                  '<li>' .
                    '<a href="#" class="ipebo-btn ipebo-btn-xs ipebo-btn-danger ipebo-item-ebook-delete" data-id="' . $itemId . '">' .
                      '<i class="ipebo-fa ipebo-fa-trash"></i>' .
                      __( 'Delete Ebook', IPEBO_SLUG ) .
                    '</a>' .
                  '</li>' .
                '</ul>' .
              '</div>' .
            '</div>' .
          '</div>' .
        '</div>';
      return $result;
    }

    //}}
    //{{ _getLinkEdit

    /**
     * Get link edit
     *
     * @param  object $item
     * @return string
     */
    protected function _getLinkEdit( $item )
    {
      $link = admin_url() . 'admin.php?page=' . IPEBO_PAGENAME . '&action=edit&id=' . $item->ID;
      return $link;
    }

    //}}
    //{{ _getPaginationLink

    /**
     * Get pagination link
     *
     * @param  int $page
     * @return string
     */
    protected function _getPaginationLink( $page )
    {
      $link = admin_url() . 'admin.php?page=' . IPEBO_PAGENAME . '&paged=' . $page;
      return $link;
    }

    //}}
  }

}
