<?php
/**
 * Class for create list object
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_List' )) 
{
  class IPEbo_List
  {
    //{{ properties

    /**
     * Take query object
     * @var WP_Query
     */
    protected $_query;

    /**
     * Take data result
     * @var int
     */
    protected $_result;

    /**
     * Take number of data
     * @var int
     */
    protected $_total;

    /**
     * Take number of page
     * @var int
     */
    protected $_total_page;

    /**
     * Take page number
     * @var int
     */
    protected $_page;

    /**
     * Take number of data per page
     * @var int
     */
    protected $_perPage;

    //}}
    //{{ __construct

    /**
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
      $page = 1;
      if ( ! empty( $_GET['paged'] )) {
        $page = absint( $_GET['paged'] );
      }
      $this->_page     = $page;
      $this->_perPage = 12;
    }

    //}}
    //{{ create

    /**
     * Create list
     *
     * @return string
     */
    public function create()
    {
      //Get data
      $this->_getData();
      //Build list
      return $this->_build();
    }

    //}}
    //{{ render

    /**
     * Render list
     *
     * @return void
     */
    public function render()
    {
      echo $this->create();
    }

    //}}
    //{{ _getData

    /**
     * Get data
     *
     * @return void
     */
    protected function _getData()
    {
      return;
    }

    //}}
    //{{ _build

    /**
     * Build list
     *
     * @return void
     */
    protected function _build()
    {
      $list  = $this->_getActionTop();
      $list .= $this->_getList();
      $list .= $this->_getActionBottom();
      $list  = $this->_getContainer( $list );
      return $list;
    }

    //}}
    //{{ _getList

    /**
     * Get list
     *
     * @return string
     */
    protected function _getList()
    {
      $list = '<div class="ipebo-the-list">';
      if ( empty( $this->_result )) {
        $list .= $this->_getEmptyList();
      }
      else
      {
        $index = 1;
        foreach( $this->_result as $item ) {
          $list .= $this->_getListItem( $item, $index );
          $index++;
        }
      }
      $list .= '</div>';
      return $list;
    }

    //}}
    //{{ _getListItem

    /**
     * Get list item
     *
     * @param  object $item
     * @param  int    $index
     * @return string
     */
    protected function _getListItem( $item, $index )
    {
      $alt = '';
      if ( $index % 2 ) {
        $alt = ' ipebo-alt';
      }
      $itemId  = $this->_getListItemId( $item );
      $result  = '<div id="ipebo-item-' . $itemId . '" class="ipebo-list-item' . $alt . '">';
      $result .= '<div class="ipebo-item-inner row">';
      $result .= $this->_getItemMain  ( $item, $index );
      $result .= $this->_getItemAction( $item, $index );
      $result .= '</div>';
      $result .= '</div>';
      return $result;
    }

    //}}
    //{{ _getItemMain

    /**
     * Get item main
     *
     * @param  object $item
     * @param  int    $index
     * @return string
     */
    protected function _getItemMain( $item, $index )
    {
      $title  = $this->_getListItemTitle( $item );
      $date   = mysql2date( 'F d Y, h:i', $this->_getListItemDate( $item ) );

      $link   = $this->_getLinkEdit( $item );
      $label  = $this->_getItemMainLabel( $item, $index );

      $result = '<div class="col-sm-6">' .
                      '<div class="ipebo-clear">' .
                          '<div class="ipebo-item-main">' .
                              '<h3 class="ipebo-item-title">' .
                                  '<a href="' . $link . '">' . $title . '</a>' .
                                  $label .
                              '</h3>' .
                              '<p class="ipebo-item-create">' .
                                  '<i class="ipebo-fa ipebo-fa-calendar"></i>' .
                                  $date .
                              '</p>' .
                          '</div>' .
                      '</div>' .
                 '</div>';
      return $result;
    }

    //}}
    //{{ _getItemMainLabel

    /**
     * Get item main label
     *
     * @param  object $item
     * @param  int    $index
     * @return string
     */
    protected function _getItemMainLabel( $item, $index )
    {
      if ( $item->post_status == 'publish' ) {
        $label = '<span class="ipebo-label ipebo-label-success">' . __( 'Publish', IPEBO_SLUG ) . '</span>';
      } else {
        $label = '<span class="ipebo-label ipebo-label-danger">' . __( 'Draft', IPEBO_SLUG ) . '</span>';
      }
      return $label;
    }

    //}}
    //{{ _getItemAction

    /**
     * Get item action
     *
     * @param  object $item
     * @param  int    $index
     * @return string
     */
    protected function _getItemAction( $item, $index )
    {
      $itemId  = $this->_getListItemId( $item );
      $result  =
        '<div class="col-sm-6">' .
          '<div class="ipebo-item-action ipebo-clear text-right">' .
            $this->_getItemStat( $item, $index ) .

            '<div class="ipebo-item-nav ipebo-fademenu">' .
              '<div class="ipebo-fademenu-inner">' .
                '<div class="ipebo-nav-label ipebo-fademenu-button">' .
                  '<a class="ipebo-menu-link" href="#"><i class="ipebo-fa ipebo-fa-bars"></i></a>' .
                '</div>' .
                '<ul class="ipebo-submenu ipebo-fademenu-content">' .
                  '<li>' .
                    '<a href="' . $this->_getLinkEdit( $item ) . '" class="ipebo-btn ipebo-btn-xs ipebo-btn-success">' .
                      '<i class="ipebo-fa ipebo-fa-pencil"></i>' .
                       __( 'Edit Modal', IPEBO_SLUG ) .
                    '</a>' .
                  '</li>' .
                  '<li>' .
                    '<a href="#" class="ipebo-btn ipebo-btn-xs ipebo-btn-danger ' . $this->_itemDelateClass . '" data-id="' . $itemId . '">' .
                      '<i class="ipebo-fa ipebo-fa-trash"></i>' .
                      __( 'Delete Modal', IPEBO_SLUG ) .
                    '</a>' .
                  '</li>' .
                '</ul>' .
              '</div>' .
            '</div>' .
          '</div>' .
        '</div>';
      return $result;
    }

    //}}
    //{{ _getItemStat

    /**
     * Get statistik information for item
     *
     * @param  object $item
     * @return string
     */
    protected function _getItemStat( $item, $index )
    {
      return '';
    }

    //}}
    //{{ _getLinkEdit

    /**
     * Get link edit
     *
     * @param  object $item
     * @return string
     */
    protected function _getLinkEdit( $item )
    {
      $link = admin_url() . 'admin.php?page=ipebo&action=edit&id=' . $item->ID;
      return $link;
    }

    //}}
    //{{ _getEmptyList

    /**
     * Get empty list
     *
     * @return string
     */
    protected function _getEmptyList()
    {
      return '<div class="ipebo-list-empty">' .
                  '<p><em>' . __( 'Data not available', IPEBO_SLUG ) . '</em></p>' .
              '</div>';
    }

    //}}
    //{{ _getListItemId

    /**
     * Get list item ID
     *
     * @param  object $item
     * @return string
     */
    protected function _getListItemId( $item )
    {
      return $item->ID;
    }

    //}}
    //{{ _getListItemTitle

    /**
     * Get list item title
     *
     * @param  object $item
     * @return string
     */
    protected function _getListItemTitle( $item )
    {
      return $item->post_title;
    }

    //}}
    //{{ _getListItemDate

    /**
     * Get list item date
     *
     * @param  object $item
     * @return string
     */
    protected function _getListItemDate( $item )
    {
      return $item->post_date;
    }

    //}}
    //{{ _getPagination

    /**
     * Get pagination
     *
     * @return string
     */
    protected function _getPagination()
    {
      $result = '';
      if ( $this->_needPagination() )
      {
        $result = '<div class="ipebo-pagination ipebo-clear">' .
                    $this->_getPaginationTotal() .
                    $this->_getPaginationMenu() .
                  '</div>';
      }
      return $result;
    }

    //}}
    //{{ _needPagination

    /**
     * Check is need pagination or not
     *
     * @return string
     */
    protected function _needPagination()
    {
      $is_need = false;
      if ( ! empty( $this->_result ) && $this->_total_page > 1 ) {
        $is_need = true;
      }
      return $is_need;
    }

    //}}
    //{{ _getTotalPage

    /**
     * Get total page
     *
     * @return int
     */
    protected function _getTotalPage()
    {
      $total_page = ceil( $this->_total/$this->_perPage );
      return $total_page;
    }

    //}}
    //{{ _getPaginationTotal

    /**
     * Get pagination total info
     *
     * @return string
     */
    protected function _getPaginationTotal()
    {
      $total  = $this->_total;
      $result = '<div class="ipebo-total">' .
                  sprintf( _n( '1 item', '%s items', $total, IPEBO_SLUG ), $total ) .
                '</div>';
      return $result;
    }

    //}}
    //{{ _getPaginationMenu

    /**
     * Get pagination menu
     *
     * @return string
     */
    protected function _getPaginationMenu()
    {
      $result = '<div class="ipebo-pagination-menu">' .
                  $this->_getPaginationFirst() .
                  $this->_getPaginationPrevious() .
                  $this->_getPaginationPageInfo() .
                  $this->_getPaginationNext() .
                  $this->_getPaginationLast() .
                '</div>';
      return $result;
    }

    //}}
    //{{ _getPaginationFirst

    /**
     * Get pagination go first menu
     *
     * @return string
     */
    protected function _getPaginationFirst()
    {
      $result = '';
      $link   = $this->_getPaginationLink( 1 );
      $class  = 'ipebo-pagin ipebo-pagin-first';
      if ( $this->_page == 1 || $this->_total_page < 3 ) {
        $class .= ' disabled';
      }
      $result = '<a class="' . $class . '" href="' . $link . '"><i class="ipebo-fa ipebo-fa-angle-double-left"></i></a>';
      return $result;
    }

    //}}
    //{{ _getPaginationLast

    /**
     * Get pagination go last menu
     *
     * @return string
     */
    protected function _getPaginationLast()
    {
      $result = '';
      $link   = $this->_getPaginationLink( $this->_total_page );
      $class  = 'ipebo-pagin ipebo-pagin-last';
      if ( $this->_page == $this->_total_page || $this->_total_page < 3 ) {
        $class .= ' disabled';
      }
      $result = '<a class="' . $class . '" href="' . $link . '"><i class="ipebo-fa ipebo-fa-angle-double-right"></i></a>';
      return $result;
    }

    //}}
    //{{ _getPaginationPrevious

    /**
     * Get pagination previous menu
     *
     * @return string
     */
    protected function _getPaginationPrevious()
    {
      $result = '';
      $class  = 'ipebo-pagin ipebo-pagin-previous';
      $page   = $this->_page - 1;
      if ( $page < 1 ) {
        $page = 1;
        $class .= ' disabled';
      }
      $link = $this->_getPaginationLink( $page );
      $result = '<a class="' . $class . '" href="' . $link . '"><i class="ipebo-fa ipebo-fa-angle-left"></i></a>';
      return $result;
    }

    //}}
    //{{ _getPaginationNext

    /**
     * Get pagination next menu
     *
     * @return string
     */
    protected function _getPaginationNext()
    {
      $result = '';
      $class  = 'ipebo-pagin ipebo-pagin-next';
      $page   = $this->_page + 1;
      if ( $page > $this->_total_page ) {
        $page = $this->_total_page;
        $class .= ' disabled';
      }
      $link = $this->_getPaginationLink( $page );
      $result = '<a class="' . $class . '" href="' . $link . '"><i class="ipebo-fa ipebo-fa-angle-right"></i></a>';
      return $result;
    }

    //}}
    //{{ _getPaginationLink

    /**
     * Get pagination link
     *
     * @param  int $page
     * @return string
     */
    protected function _getPaginationLink( $page )
    {
      $link = admin_url() . '?page=ipebo&paged=' . $page;
      return $link;
    }

    //}}
    //{{ _getPaginationPageInfo

    /**
     * Get pagination page info
     *
     * @return string
     */
    protected function _getPaginationPageInfo()
    {
      $result = '<span class="ipebo-paged-info">' .
                  '<strong>' . $this->_page . '</strong> of <strong>' . $this->_total_page . '</strong>' .
                '</span>';
      return $result;
    }

    //}}
    //{{ _getContainer

    /**
     * Get container
     *
     * @param  string $list
     * @return string
     */
    protected function _getContainer( $list )
    {
      $result = '<div class="ipebo-manage container-fluid container">' .
                  '<div class="ipebo-manage-list ipebo-list-stat">' .
                      $list .
                  '</div>' .
                '</div>';

      return $result;
    }

    //}}
    //{{ _getActionTop

    /**
     * Get action top
     *
     * @return string
     */
    protected function _getActionTop()
    {
      return '';
    }

    //}}
    //{{ _getActionBottom

    /**
     * Get action bottom
     *
     * @return string
     */
    protected function _getActionBottom()
    {
      $action = '<div class="ipebo-action-bottom">' .
                  '<div class="row">' .
                      '<div class="col-sm-6"></div>' .
                      '<div class="col-sm-6 text-right">' .
                          $this->_getPagination() .
                      '</div>' .
                  '</div>' .
                '</div>';
      return $action;
    }

    //}}
    //{{ foundRows

    /**
     * Get found rows
     *
     * @return int
     */
    public function foundRows()
    {
      global $wpdb;
      $count   = 0;
      $query   = "SELECT FOUND_ROWS() as count";
      $count   = $wpdb->get_var( $query );
      return $count;
    }

    //}}
    //{{ trimTitle

    /**
     * Cut off title
     *
     * @param  string $title
     * @return string
     */
    public function trimTitle( $title )
    {
      if( strlen($title) > 30 ) {
        $title = substr($title, 0, 30).'...';
      }
      return $title;
    }

    //}}
  }

}