<?php
if ( ! class_exists( 'IPEbo_Font' ))
{
  /**
   * Class for create popup
   */
  class IPEbo_Font
  {
    /**
     * Get option font
     *
     * @return array
     */
    public static function getOptions()
    {
      $options = array(
        'serif' => array(
          'dejavuserif'           => 'DeJaVu Serif',
          'dejavuserifcondensed'  => 'DeJaVu Condensed',
          'freeserif'             => 'Free Serif',
          'cormorant_garamond'    => 'Cormorant Garamond',
          'droid_serif'           => 'Droid Serif',
          'libre_baskerville'     => 'Libre Baskerville',
          'merriweather'          => 'Merriweather',
          'old_standard_tt'       => 'Old Standard TT',
          'playfair_display'      => 'Playfair Display',
          'roboto_slab'           => 'Roboto Slab',
          'taviraj'               => 'Taviraj',
        ),
        'sans-serif' => array(
          'dejavusans'          => 'DeJaVu Sans',
          'dejavusanscondensed' => 'DeJaVu Sans Condensed',
          'freesans'            => 'Free Sans',
          'archivo_narrow'      => 'Archivo Narrow',
          'arimo'               => 'Arimo',
          'exo2'                => 'Exo 2',
          'josefin_sans'        => 'Josefin Sans',
          'lato'                => 'Lato',
          'raleway'             => 'Raleway',
          'roboto'              => 'Roboto',
          'roboto_condensed'    => 'Roboto Condensed',
          'rosario'             => 'Rosario',
        ),
        'monospace' => array(
          'dejavusansmono'  => 'DeJaVu Sans Mono',
          'freemono'        => 'Free Mono'
        ),
        'cursive' => array(
          'arimamadurai'    => 'Arima Madurai',
          'audiowide'       => 'Audiowide',
          'chewy'           => 'Chewy',
          'comfortaa'       => 'Comfortaa',
          'knewave'         => 'Knewave',
          'lobster'         => 'Lobster',
          'oleoscript'      => 'Oleo Script',
          'playball'        => 'Playball',
          'fingerpaint'     => 'Finger Paint',
          'katibeh'         => 'Katibeh',
          'sail'            => 'Sail',
          'stardosstencil'  => 'Stardos Stencil',
          'unifrakturmaguntia'  => 'Unifraktur Maguntia',
          'vastshadow'          => 'Vast Shadow'
        )
      );
      return $options;
    }

    /**
     * Get font name
     *
     * @return array
     */
    public static function getFontName( $key )
    {
      $name    = 'Font';
      $options = self::getOptions();
      foreach( $options as $gid => $items )
      {
        foreach( $items as $id => $label )
        {
          if ( $key == $id ) {
            $name = $label;
          }
        }
      }
      return $name;
    }
  }
}
