<?php
if ( ! class_exists( 'IPEbo_Creator_Content' ))
{
  /**
   * Ebook creator class
   *
   * @package wp-ebook-creator
   * @author InstaProduct
   * @link http://insta-product.com/
   */

  class IPEbo_Creator_Content
  {
    //{{ parameters

    /**
     * Take page
     *
     * @var object
     */
    protected $_page;

    /**
     * Take settings
     *
     * @var object
     */
    protected $_settings;

    /**
     * Take is admin
     *
     * @var boolean
     */
    protected $_isAdmin;

    /**
     * Take is cover
     *
     * @var boolean
     */
    protected $_isCover;

    //}}
    //{{ __construct

    /**
     * Class constructor
     *
     * @param  object $page
     * @param  object $settings
     * @return void
     */
    public function __construct( $page, $settings, $isCover = false, $isAdmin = false )
    {
      $this->_page     = $page;
      $this->_settings = $settings;
      $this->_isAdmin  = $isAdmin;
      $this->_isCover = $isCover;
    }

    //}}
    //{{ getPageContent

    /**
     * Get page content
     *
     * @return string
     */
    public function getPageContent()
    {
      $r  = '<div class="ipebo-ebook-section ipebo-ebook-page">';
      $r .= $this->_main();
      $r .= '</div>';

      return $r;
    }

    //}}
    //{{ getCoverContent

    /**
     * Get cover content
     *
     * @return string
     */
    public function getCoverContent()
    {
      $r  = '<div class="ipebo-ebook-section ipebo-ebook-cover">';
      $r .= $this->_main();
      $r .= '</div>';

      return $r;
    }

    //}}
    //{{ _main

    /**
     * Get main content
     *
     * @return string
     */
    protected function _main()
    {
      $r = '';
      $settings = $this->_settings;

      //Fonts
      if ( $this->_isAdmin )
      {
        $titleFont   = $settings->getSetting( 'title_font', 'playfair_display');
        $contentFont = $settings->getSetting( 'content_font', 'roboto');
        $titlecss    = IPEBO_BASE_URL . 'assets/css/fonts/' . $titleFont . '.css';
        $contentcss  = IPEBO_BASE_URL . 'assets/css/fonts/' . $contentFont . '.css';

        $r .= '<link id="ipebo-font-import-title" href="' . $titlecss . '" rel="stylesheet">';
        $r .= '<link id="ipebo-font-import-content" href="' . $contentcss . '" rel="stylesheet">';
      }
      $maincss    = IPEBO_BASE_URL . 'assets/css/ebook.css';
      $csscontent = file_get_contents( $maincss );
      $r .= '<style>';
      $r .= $csscontent;
      $r .= '</style>';

      $layout  = $settings->getSetting( 'content_layout', 1 );
      if ( $layout == 4 ) {
        $bgcolor = $settings->getSetting( 'content_bgcolor', '#ffffff' );
      } else {
        $bgcolor = $settings->getSetting( 'page_bgcolor', '#ffffff' );
      }
      $layout = $settings->getSetting( 'content_layout', 1 );
      $class  = 'ipebo-ebook-page-inner';
      if ( $layout == 4 ) {
        $class .= ' ipebo-change-content-background';
      } else {
        $class .= ' ipebo-change-page-background';
      }
      //BG
      $class .= ' ipebo-change-background-image';
      $style = $this->_getStylePage();
      $r .= '<div class="ipebo-ebook-wrapper ipebo-change-layout ipebo-layout-'. $layout . '" data-layout="' . $layout . '">';
      $r .= '<div class="' . $class . '" style="' . $style . '">';

      //Main
      $style = $this->_getStyleMain();
      $class = 'ipebo-ebook-main';
      if ( $layout == 1 ) {
        $class .= ' ipebo-change-content-background';
      }

      $r .= '<div class="' . $class . '" style="' . $style . '">';
      $r .= $this->_header();
      $r .= $this->_content();
      $r .= '</div>'; //End .ipebo-ebook-main

      $r .= '</div>'; //End .ipebo-change-page-background
      $r .= '</div>'; //End .ipebo-ebook-setting

      return $r;
    }

    //}}
    //{{ _header

    /**
     * Get header content
     *
     * @return string
     */
    protected function _header()
    {
      $settings = $this->_settings;
      $page     = $this->_page;

      $style = $this->_getStyleHeader();

      $layout = $settings->getSetting( 'content_layout', 1 );
      $class  = 'ipebo-ebook-header-inner';
      if ( $layout == 2 || $layout == 3 || $layout == 4 ) {
        $class .= ' ipebo-change-page-background';
      }

      $r  = '<div class="ipebo-ebook-header">';
      $r .= '<div class="' . $class . '" style="' . $style . '">';

      //Cover logo
      if ( $this->_isCover )
      {
        $coverLogoSrc = '';
        $coverLogoDsp = ' style="display:none;"';
        if ( $imgid = $settings->getSetting( 'cover_logo' ) )
        {
          $imgdata = wp_get_attachment_image_src( $imgid, 'full' );
          $coverLogoSrc = $imgdata[0];
          $coverLogoDsp = '';
        }

        $r .= '<div class="ipebo-ebook-cover-logo ipebo-change-cover-logo"' . $coverLogoDsp . '>';
        $r .= '<img src="' . $coverLogoSrc . '" alt="">';
        $r .= '</div>';
      }

      //Title
      $font  = $settings->getSetting( 'title_font', 'playfair_display' );
      $cfont = $settings->getSetting( 'content_font', 'roboto' );
      $color = $settings->getSetting( 'title_color', '#000000' );
      $style = $this->_getStyleTitle();

      $r .= '<h2 class="ipebo-ebook-title ipebo-change-title-color ipebo-change-title-font" style="' . $style . '">';
      $r .= '<span class="ipebo-change-title">';
      $r .= stripslashes( $page->post_title );
      $r .= '</span>';
      $r .= '</h2>';

      //Article author
      $pageType = $settings->getSetting( 'page_type', 'article' );
      if ( ! $this->_isCover && $pageType == 'article' )
      {
        $author = $settings->getSetting( 'article_author', '' );
        $style  = ' style="font-family:' . $cfont . ';color:' . $color . ';"';

        $r .= '<div class="ipebo-ebook-author ipebo-change-author ipebo-change-title-color ipebo-change-content-font"' . $style . '>';
        $r .= $author;
        $r .= '</div>';
      }

      $r .= '</div>'; //End .ipebo-ebook-header-inner
      $r .= '</div>'; //End .ipebo-ebook-header

      return $r;
    }

    //}}
    //{{ _content

    /**
     * Get main content
     *
     * @return string
     */
    protected function _content()
    {
      $settings = $this->_settings;
      $page     = $this->_page;
      $layout   = $settings->getSetting( 'content_layout', 1 );

      $class = 'ipebo-ebook-content ipebo-change-content-color ipebo-change-content-font';
      if ( $layout != 1 ) {
        $class .= ' ipebo-change-content-background';
      }
      $style = $this->_getStyleContent();

      $r  = '';
      $r .= '<div class="' . $class . '" style="' . $style . '">';
      $r .= '<div class="ipebo-ebook-content-inner">';

      //Content cover
      if ( $this->_isCover )
      {
        $r .= $this->_contentCover();
      }
      else
      {
        $pageType = $settings->getSetting( 'page_type', 'article' );
        if ( $pageType == 'table' ) {
          $r .= $this->_contentTable();
        }
        elseif ( $pageType == 'action' ) {
          $r .= $this->_contentAction();
        }
        else {
          $r .= $this->_contentArticle();
        }
      }

      $r .= '</div>';
      $r .= '</div>';

      return $r;
    }

    //}}
    //{{ _contentCover

    /**
     * Get content cover
     *
     * @return string
     */
    protected function _contentCover()
    {
      $settings = $this->_settings;
      $page     = $this->_page;

      $r  = '<div class="ipebo-ebook-content-main ipebo-ebook-content-cover">';

      //Image
      $imgsrc = '';
      $dspimg = ' style="display:none;"';
      if ( $imgid = $settings->getSetting( 'cover_image' ) ) {
        $imgdata = wp_get_attachment_image_src( $imgid, 'full' );
        $imgsrc  = $imgdata[0];
        $dspimg  = '';
      }
      $r .= '<div class="ipebo-ebook-cover-image ipebo-change-cover-image"' . $dspimg . '>';
      $r .= '<span>';
      $r .= '<img src="' . $imgsrc . '" alt="">';
      $r .= '</span>';
      $r .= '</div>';

      //Summary
      $summary = $settings->getSetting( 'cover_summary' , '' );
      $style   = $this->_getStyleSummary();

      $r .= '<div class="ipebo-ebook-cover-summary ipebo-change-cover-summary">';
      $r .= stripslashes( $summary );
      $r .= '</div>';

      $r .= '</div>';

      return $r;
    }

    //}}
    //{{ _contentArticle

    /**
     * Get content article
     *
     * @return string
     */
    protected function _contentArticle()
    {
      $settings = $this->_settings;
      $page     = $this->_page;

      $r  = '<div class="ipebo-ebook-content-main ipebo-ebook-content-article">';

      //Summary
      $summary = '';
      if ( ! empty( $page->post_excerpt ) ) {
        $summary = $page->post_excerpt;
      }
      //$style = $this->_getStyleSummary();
      $r .= '<div class="ipebo-ebook-article-summary ipebo-change-article-summary">';
      $r .= stripslashes( $summary );
      $r .= '</div>';

      //Content
      $content = '';
      if ( ! empty( $page->post_content ) ) {
        $content = $page->post_content;
      }
      $r .= '<div class="ipebo-ebook-article-content ipebo-change-article-content">';
      $r .= stripslashes( $content );
      $r .= '</div>';

      $r .= '</div>';

      return $r;
    }

    //}}
    //{{ _contentTable

    /**
     * Get content table
     *
     * @return string
     */
    protected function _contentTable()
    {
      $settings = $this->_settings;
      $page     = $this->_page;

      $r  = '<div class="ipebo-ebook-content-main ipebo-ebook-content-table">';

      //Content
      $content = '';
      if ( ! empty( $page->post_content ) ) {
        $content = $page->post_content;
      }
      $r .= '<div class="ipebo-ebook-table-content ipebo-change-table-content">';
      $r .= stripslashes( $content );
      $r .= '</div>';

      $r .= '</div>';

      return $r;
    }

    //}}
    //{{ _contentAction

    /**
     * Get content action
     *
     * @return string
     */
    protected function _contentAction()
    {
      $settings = $this->_settings;
      $page     = $this->_page;

      $r  = '<div class="ipebo-ebook-content-main ipebo-ebook-content-action">';

      //Content
      $content = '';
      if ( ! empty( $page->post_content ) ) {
        $content = $page->post_content;
      }
      $r .= '<div class="ipebo-ebook-action-content ipebo-change-action-content">';
      $r .= stripslashes( $content );
      $r .= '</div>';

      //Button
      $label    = $settings->getSetting( 'action_button_label', '' );
      $url      = $settings->getSetting( 'action_button_url', '' );
      $template = $settings->getSetting( 'action_button_template', 1 );
      $color    = $settings->getSetting( 'action_button_color', 'clean' );
      $size     = $settings->getSetting( 'action_button_size', 'md' );
      $btndsp   = ' style="display:none;"';
      if ( ! empty( $label ) && ! empty( $url ) ) {
        $btndsp = '';
      }

      $r .= '<div class="ipebo-ebook-action-button"' . $btndsp . '>';
      $r .= '<a class="ipebo-button ipebo-button-' . $size . ' ipebo-button-' . $color . '" href="' . $url . '">';
      $r .= $label;
      $r .= '</a>';
      $r .= '</div>';

      $r .= '</div>';

      return $r;
    }

    //}}
    //{{ _getStylePage

    /**
     * Get style page
     *
     * @return string
     */
    protected function _getStylePage()
    {
      $settings = $this->_settings;
      $page     = $this->_page;
      $layout   = $settings->getSetting( 'content_layout', 1 );
      if ( $layout == 4 ) {
        $bgcolor = $settings->getSetting( 'content_bgcolor', '#ffffff' );
      } else {
        $bgcolor = $settings->getSetting( 'page_bgcolor', '#ffffff' );
      }

      //Background image
      $bgimageSrc = '';
      $bgimageDsp = ' style="display:none;"';
      if ( $imgid = $settings->getSetting( 'bgimage' ) )
      {
        $imgdata    = wp_get_attachment_image_src( $imgid, 'full' );
        $bgimageSrc = $imgdata[0];
        $bgimageDsp = '';
      }

      $style   = '';
      $style  .= 'width:680px;';
      //$style  .= 'height:1000px;';
      $style  .= 'background-color:' . $bgcolor . ';';

      if ( ! empty( $bgimageSrc )) {
        $style .= 'background-image:url(' . $bgimageSrc . ');';
      }

      return $style;
    }

    //}}
    //{{ _getStyleMain

    /**
     * Get style main
     *
     * @return string
     */
    protected function _getStyleMain()
    {
      $settings = $this->_settings;
      $page     = $this->_page;
      $layout   = $settings->getSetting( 'content_layout', 1 );
      $bgcolor  = $settings->getSetting( 'content_bgcolor', '#ffffff' );

      $style   = '';

      //BG Color
      if ( $layout == 1 || $layout == 5 || $layout == 6 ) {
        $style .= 'background-color:' . $bgcolor . ';';
      }

      return $style;
    }

    //}}
    //{{ _getStyleTitle

    /**
     * Get style title
     *
     * @return string
     */
    protected function _getStyleTitle()
    {
      $settings = $this->_settings;
      $page     = $this->_page;

      $font   = $settings->getSetting( 'title_font', 'playfair_display' );
      $cfont  = $settings->getSetting( 'content_font', 'roboto' );
      $color  = $settings->getSetting( 'title_color', '#000000' );
      $style  = '';
      $style .= 'font-family:' . $font . ';';
      $style .= 'color:' . $color . ';';

      return $style;
    }

    //}}
    //{{ _getStyleHeader

    /**
     * Get style header
     *
     * @return string
     */
    protected function _getStyleHeader()
    {
      $settings = $this->_settings;
      $page     = $this->_page;
      $layout   = $settings->getSetting( 'content_layout', 1 );

      $style  = '';
      if ( $layout == 4 ) {
        $bgcolor = $settings->getSetting( 'page_bgcolor', '#ffffff' );
        $style  .= ' background-color:' . $bgcolor . ';';
      }

      return $style;
    }

    //}}
    //{{ _getStyleContent

    /**
     * Get style content
     *
     * @return string
     */
    protected function _getStyleContent()
    {
      $settings = $this->_settings;
      $page     = $this->_page;

      $font     = $settings->getSetting( 'content_font', 'roboto' );
      $color    = $settings->getSetting( 'content_color', '#333333' );
      $bgcolor  = $settings->getSetting( 'content_bgcolor', '#ffffff' );

      $style  = '';
      $style .= 'font-family:' . $font . ';';
      $style .= 'color:' . $color . ';';
      //BG Color
      if ( $layout != 1 ) {
        $style .= 'background-color:' . $bgcolor . ';';
      }

      return $style;
    }

    //}}
    //{{ _getStyleSummary

    /**
     * Get style summary
     *
     * @return string
     */
    protected function _getStyleSummary()
    {
      $settings = $this->_settings;
      $page     = $this->_page;

      $font     = $settings->getSetting( 'content_font', 'roboto' );
      $color    = $settings->getSetting( 'content_color', '#333333' );
      $bgcolor  = $settings->getSetting( 'content_bgcolor', '#ffffff' );

      $style  = '';
      $style .= 'margin-bottom:8pt;';
      $style .= 'font-size:10pt;';
      $style .= 'font-style:italic;';

      return $style;
    }
    //}}
  }
}
