<?php
if ( ! class_exists( 'IPEbo_Creator' ))
{
  /**
   * Ebook creator class
   *
   * @package wp-ebook-creator
   * @author InstaProduct
   * @link http://insta-product.com/
   */

  class IPEbo_Creator
  {
    //{{ init

    /**
     * Init
     *
     * @return void
     */
    public function init()
    {
      if ( isset( $_GET['page'] ) && $_GET['page'] == IPEBO_PAGENAME &&
					 isset( $_GET['action'] ) && $_GET['action'] == 'preview' &&
					 isset( $_GET['id'] ) && ! empty( $_GET['id'] )
			){
        $ebookId = absint( $_GET['id'] );
        $ebook   = get_post( $ebookId );
        if ( ! $ebook ) {
          wp_die( __('You attempted to preview an ebook that doesn&#8217;t exist. Perhaps it was deleted?', IPEBO_SLUG ) );
        }
        //Start create ebook
        $this->_create( $ebook );
			}
    }

    //}}
    //{{ _create

    /**
     * Creating ebook
     *
     * @param  object $ebook
     * @return void
     */
    protected function _create( $ebook )
    {
      $mpdf     = new mPDF();
      $settings = new IPEbo_Setting( $ebook->ID, '__ipebo_ebook_setting' );

      //Add css
      $maincss    = IPEBO_BASE_URL . 'assets/css/ebook.css';
      $csscontent = file_get_contents( $maincss );
      $mpdf->WriteHTML( $csscontent, 1 );

      //Add cover
      $cover = $this->_getCoverContent( $ebook, $settings );
      if ( ! empty( $cover )) {
        $mpdf->WriteHTML( $cover );
      }

      //Add pages
      $pages = $this->_getPages( $ebook, $settings );
      if ( ! empty( $pages ))
      {
        foreach( $pages as $page )
        {
          $content = $this->_getPageContent( $page );
          if ( ! empty( $content ))
          {
            $mpdf->AddPage();
            $mpdf->WriteHTML( $content );
          }
        }
      }

      //Start print ebook
      $mpdf->Output();
      die();
    }

		//}}
		//{{ _getCoverContent

    /**
     * Get cover content
     *
     * @param  object $ebook
     * @param  object $settings
     * @return void
     */
    protected function _getCoverContent( $ebook, $settings )
    {
      $creator = new IPEbo_Creator_Content( $ebook, $settings, true );
      $content = $creator->getCoverContent();
      return $content;
    }

		//}}
		//{{ _getPageContent

    /**
     * Get page content
     *
     * @param  object $page
     * @return void
     */
    protected function _getPageContent( $page )
    {
      $settings = new IPEbo_Setting( $page->ID, '__ipebo_ebook_page_setting' );
      $creator  = new IPEbo_Creator_Content( $page, $settings );
      $content  = $creator->getPageContent();
      return $content;
    }

    //}}
    //{{ _getPages

    /**
     * Creating ebook
     *
     * @param  object $ebook
     * @param  object $settings
     * @return void
     */
    protected function _getPages( $ebook, $settings )
    {
      $pages     = array();
      if ( $_ids = $settings->getSetting( 'ebook_posts' ) )
      {
        $ids = explode( '|', $_ids );
        foreach( $ids as $id )
        {
          $id = absint( $id );
          $post = get_post( $id );
          if ( $post ) {
            $pages[] = $post;
          }
        }
      }
      return $pages;
    }

    //}}
  }
}
