<?php
/**
 * Class helper for create admin page
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Admin_Main' ))
{
  class IPEbo_Admin_Main extends IPEbo_Admin
  {
  	//{{ parameters

		/**
		 * Take object
		 *
		 * @var object
		 */
		public $object = false;

		/**
		 * Is dashboard page?
		 *
		 * @var boolean
		 */
		public $isDashboard = false;

		/**
		 * Is edit page?
		 *
		 * @var boolean
		 */
		public $isEdit = false;

		/**
		 * Is import page?
		 *
		 * @var boolean
		 */
		public $isImport = false;

		/**
		 * Take setting name
		 *
		 * @var string
		 */
		protected $_settingName;

		/**
		 * Take root page ID
		 *
		 * @var string
		 */
		protected $_rootPageID;

		/**
		 * Take action name
		 *
		 * @var string
		 */
		protected $_actionName;

		//}}
		//{{ __construct

		/**
		 * Class construct
		 *
		 * @param array $config
		 * @return void
		 */
		public function __construct( $config = array() )
		{
			parent::__construct( $config );

			//Check page
			$this->_checkPage();
		}

		//}}
		//{{ build

		/**
		 * Build admin page
		 *
		 * @return void
		 */
		public function build()
		{
			parent::_setViewData();

      //Edit page
      if ( $this->isEdit )
      {
      	$this->_getObject();
      	$this->edit();
      }
	    //Importing page
	    elseif ( $this->isImport )
	    {
      	$this->_getObject();
	    	$this->import();
	    }
      //Dashboard page
      else {
        $this->dashboard();
      }
		}

		//}}
		//{{ main

		/**
		 * Main content
		 *
		 * @return void
		 */
		public function main()
		{
			//Edit page
      if ( $this->isEdit )
      {
      	$this->view( 'main/edit', 'admin' );
	    }
			//Importing page
      else if ( $this->isImport )
      {
      	$this->view( 'main/import', 'admin' );
	    }
      //Dashboard page
      else
      {
      	$this->view( 'main', 'admin' );
      }
		}

		//
		//{{ edit

		/**
		 * Admin main edit page
		 *
		 * @return void
		 */
		public function edit()
		{
      //
      //Including script
      wp_enqueue_media();
      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

			$this->pageID    = 'ipebo-page-ebook-edit';
			$this->requestID = IPEBO_PAGENAME;
      $this->ebook     = $this->object;
      $this->settings  = new IPEbo_Setting( $this->ebook->ID, '__ipebo_ebook_setting' );

      //Get pages
      $pages = array();
      if ( $_ids = $this->settings->getSetting( 'ebook_posts' ) )
      {
        $ids = explode( '|', $_ids );
        foreach( $ids as $id )
        {
          $id = absint( $id );
          $post = get_post( $id );
          if ( $post ) {
            $pages[] = $post;
          }
        }
      }
      $this->pages = $pages;

			$this->view( 'container' );
		}

		//
		//{{ import

		/**
		 * Admin main edit page
		 *
		 * @return void
		 */
		public function import()
		{
			$this->pageID    = 'ipebo-page-ebook-import';
			$this->requestID = IPEBO_PAGENAME;

      //Header content
      $this->title      = __( 'Import Posts', IPEBO_SLUG );
      $this->info       =  __( 'Importing posts to be added to the ebook.', IPEBO_SLUG );
      $this->formAction = admin_url( 'admin-ajax.php' ) . '?doajax=1&ipebo=1&action=update_ebook';
      $this->ebook      = $this->object;

			$this->view( 'container' );
		}

		//
		//{{ dashboard

		/**
		 * Admin dashboard page
		 *
		 * @return void
		 */
		public function dashboard()
		{
			$this->pageID    = 'ipebo-page-ebook-main';
			$this->requestID = IPEBO_PAGENAME;
			$this->view( 'container' );
		}

		//
		//{{ _setSetting

		/**
		 * Set manage setting data
		 *
		 * @return void
		 */
		public function _setSetting( $id )
		{
      $this->setting  = new IPEbo_Setting( $id, $this->_settingName );
		}

		//
		//{{ _getObject

		/**
		 * Get object data
		 *
		 * @return void
		 */
		public function _getObject()
		{
			if ( empty( $_GET['id'] )) {
        wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPEBO_SLUG ) );
      }
      $id = absint( $_GET['id'] );
      if ( ! $object = get_post( $id ) ) {
        wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPEBO_SLUG ) );
      }
      $this->object = $object;
		}

		//
		//{{ _checkPage

		/**
		 * Check page type
		 *
		 * @return void
		 */
		public function _checkPage()
		{
			if ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' ) {
      	$this->isEdit = true;
      }
	    //importing page
	    elseif ( isset( $_GET['action'] ) && $_GET['action'] == 'import' ) {
      	$this->isImport = true;
	    }
      //Dashboard page
      else {
      	$this->isDashboard = true;
      }
		}
  }
}
