<?php
/**
 * Class helper for admin create ebook page
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Admin_Create' ))
{
  class IPEbo_Admin_Create extends IPEbo_Admin
  {
		//{{ __construct

		/**
		 * Class construct
		 *
		 * @param array $config
		 * @return void
		 */
		public function __construct( $config = array() )
		{
			parent::__construct( $config );
		}

    //}}
		//{{ build

		/**
		 * Build admin page
		 *
		 * @return void
		 */
		public function build()
		{
			$this->_setViewData();

      //
      //Including script
      wp_enqueue_media();
      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

			$this->view( 'container' );
		}

		//}}
		//{{ main

		/**
		 * Main content
		 *
		 * @return void
		 */
		public function main()
		{
			$this->view( 'create', 'admin' );
		}

		//}}
		//{{ _setViewData

		/**
		 * Set view data
		 *
		 * @return void
		 */
		protected function _setViewData()
		{
			$this->requestID  = IPEBO_PAGENAME . '-create';
			$this->htmlRootID = 'ipebo-page-ebook-create';
      $this->formAction = admin_url( 'admin-ajax.php' ) . '?doajax=1&ipebo=1&action=update_ebook';
		}
  }
}
